\name{values.Widget}
\alias{values.Widget}
\alias{print.Widget}
\alias{print.pWidget}
\title{Deal with Names and Values of Widget Created by widgetRender()}
\description{
  Functions in this group print or list the names or/and values of the
  widget elements on a widget created by \code{\link{widgetRender}()}.
}
\usage{
values.Widget(x)
}

\arguments{
  \item{x}{A list (print.pWidget) or list of lists(print.Widget,
    values.Widget) that representing a widget element (list) on a widget
    or a widget (list of lists) generated by using the function widgetRender.}
}
\details{
  print.pWidget takes a list defining a widget element on a widget
  generated by using the function widgetREnder. An example of a valid
  list will be:

  pW1 <- list(Name="AAA", Value="bbb", toText=function(x)
  paste(x,collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun =
  fileBrowser, buttonText = "Browse")

  print.Widget and values.Widget take a list of lists defining all the
  widget elements on a widget generated using the function
  widgetRender. An example of a valid list will be:

  pW1 <- list(Name="AAA", Value="bbb", toText=function(x)
  paste(x,collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun =
  fileBrowser, buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z", toText=function(x) paste(x,
  sep=","), fromText=NULL, canEdit=TRUE, buttonFun = ls,  buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc", toText=function(x) paste(x,
  collapse = ","), fromText=NULL, canEdit=TRUE, buttonFun=NULL,
  buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3), preFun =
  function() "Hi", postFun = function() "Bye")

}
\value{
  \item{returnList}{values.Widget returns a list of lists each with the
    name and value of an entry box on the widget created.}
}

\author{Jianhua (John) Zhang}

\seealso{\code{\link{widgetRender}}}

\examples{
# Create the lists and list of lists
  pW1 <- list(Name="AAA", Value="bbb",
              toText=function(x) paste(x,collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun = fileBrowser,
              buttonText = "Browse")

  pW2 <- list(Name="BBB", Value="x,y,z", toText=function(x) paste(x, sep=","),
            fromText=NULL, canEdit=TRUE, buttonFun = ls,
           buttonText = "List")

  pW3 <- list(Name="CCC", Value="ccc",
              toText=function(x) paste(x, collapse = ","),
              fromText=NULL, canEdit=TRUE, buttonFun=NULL,
              buttonText=NULL)

  widget1 <- list(wList = list(a = pW1, b = pW2, c = pW3),
                  preFun = function() "Hi",
                  postFun = function() "Bye")

# Define the classes
class(pW1) <- c("pWidget", "textbox")
class(widget1) <- "Widget"

# Call the funcitons
print.pWidget(pW1)
print.Widget(widget1)
values.Widget(widget1)
}
\keyword{manip}
