\name{printGraph-methods}

\alias{GOplot}
\alias{showSigOfNodes}

\alias{printGraph-methods}
\alias{printGraph}
\alias{printGraph,topGOdata,topGOresult,numeric,missing-method}
\alias{printGraph,topGOdata,topGOresult,numeric,topGOresult-method}

\title{Visualisation functions}

\description{
  Functions to plot the subgraphs induced by the most significant GO terms 
}


\usage{
showSigOfNodes(GOdata, termsP.value, firstSigNodes = 10, reverse = TRUE,
               sigForAll = TRUE, wantedNodes = NULL, putWN = TRUE,
               putCL = 0, type = NULL, showEdges = TRUE,  swPlot = TRUE,
               useFullNames = TRUE, oldSigNodes = NULL, 
               useInfo = c("none", "pval", "counts", "def", "np", "all")[1],
               plotFunction = GOplot, .NO.CHAR = 20)

printGraph(object, result, firstSigNodes, refResult, ...) 
}

\arguments{

  \item{object}{an object of class \code{topGOdata}.}
  \item{GOdata}{an object of class \code{topGOdata}.}
  
  \item{result}{an object of class \code{topGOresult}.}
  \item{firstSigNodes}{the number of top scoring GO terms which .... }
  \item{refResult}{an object of class \code{topGOresult}.}

  \item{termsP.value}{named vector of p-values.}
  \item{reverse}{the direction of the edges.}
  \item{sigForAll}{if \code{TRUE} the score/p-value of all nodes in the DAG is
    shown, otherwise only the score for the \code{sigNodes}}
  \item{wantedNodes}{the nodes that we want to find, we will plot this nodes with
    a different color. The vector contains the names of the nodes}
  \item{putWN}{the graph is generated with using the firstSigNodes and the
    wantedNodes.}
  \item{putCL}{we generate the graph from the nodes given by all previous
    parameters, plus their children. if putCL = 1 than only the 
    children are added, if putCL = n we get the nodes form the
    next n levels.}
  \item{type}{used for plotting pie charts}
  \item{showEdges}{if \code{TRUE} the edge are shown}
  \item{swPlot}{if true the graph is ploted, if not no plotting is done.}
  \item{useInfo}{additional info to be ploted to each node.}
  \item{oldSigNodes}{used to plot the (new) sigNodes in the same color
    range as the old ones}
  \item{useFullNames}{argument for internal use ..}
  \item{plotFunction}{argument for internal use ..}
  \item{.NO.CHAR}{argument for internal use ..}
  
  
  
  \item{\dots}{
    Extra arguments for \code{printGraph} can be:
    \describe{
      \item{\code{fn.prefix}}{
	character string giving the file name prefix.
      }
      \item{\code{useInfo}}{
        as in \code{showSigOfNodes} function.
      }
      \item{\code{pdfSW}}{
	logical attribute switch between PDF or PS formats.
      }
    }
  }
}

\details{
  
  There are two functions available. The \code{showSigOfNodes} will plot
  the induced subgraph to the current graphic device. The
  \code{printGraph} is a warping function for \code{showSigOfNodes} and
  will save the resulting graph into a PDF or PS file. 
  
  In the plots, the significant nodes are represented as rectangles. The
  plotted graph is the upper induced graph generated by these significant nodes. 
}


\author{Adrian Alexa}

\seealso{
  \code{\link{groupStats-class}},
  \code{\link{getSigGroups-methods}}
}

\examples{

\dontrun{
data(GOdata)
data(results.tGO)

showSigOfNodes(GOdata, score(resultFisher), firstSigNodes = 5, useInfo = 'all')
printGraph(GOdata, resultFisher, firstSigNodes = 5, 
           fn.prefix = "sampleFile", useInfo = "all", pdfSW = TRUE)
}

}
\keyword{methods}
