% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diffEndTest.R
\name{diffEndTest}
\alias{diffEndTest}
\alias{diffEndTest,SingleCellExperiment-method}
\alias{diffEndTest,list-method}
\title{Perform statistical test to check for DE between final stages of every
 lineage.}
\usage{
diffEndTest(models, ...)

\S4method{diffEndTest}{SingleCellExperiment}(models, global = TRUE, pairwise = FALSE, l2fc = 0)

\S4method{diffEndTest}{list}(models, global = TRUE, pairwise = FALSE, l2fc = 0)
}
\arguments{
\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}.}

\item{...}{parameters including:}

\item{global}{If TRUE, test for all pairwise comparisons simultaneously.}

\item{pairwise}{If TRUE, test for all pairwise comparisons independently.}

\item{l2fc}{The log2 fold change threshold to test against. Note, that
this will affect both the global test and the pairwise comparisons.}
}
\value{
A matrix with the wald statistic, the number of df and the p-value
 associated with each gene for all the tests performed. Also, for each possible
 pairwise comparision, the observed log fold changes. If the testing
 procedure was unsuccessful, the procedure will return NA test statistics,
 fold changes and p-values.
}
\description{
Assess differential expression between the average expression at the
 end points of lineages of a trajectory.
}
\details{
The \code{l2fc} argument allows to test against a particular fold change
threshold. For example, if the interest lies in discovering genes that are
differentially expressed with an absolute log2 fold change cut off above 1,
i.e. a fold change of at least 2, then one can test for this by setting
\code{l2fc=1} as argument to the function.
}
\examples{
data(gamList, package = "tradeSeq")
diffEndTest(gamList, global = TRUE, pairwise = TRUE)
}
