% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\docType{methods}
\name{detectTranscripts}
\alias{detectTranscripts}
\alias{detectTranscripts,TranscriptionDataSet-method}
\title{detectTranscripts}
\usage{
detectTranscripts(
  object,
  coverage.cutoff,
  gap.dist,
  estimate.params = TRUE,
  total.reads,
  combine.by.annot = FALSE,
  annot
)

\S4method{detectTranscripts}{TranscriptionDataSet}(
  object,
  coverage.cutoff,
  gap.dist,
  estimate.params = TRUE,
  total.reads,
  combine.by.annot = FALSE,
  annot
)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{coverage.cutoff}{\code{Numeric}. A cutoff value to discard regions with
the low fragments coverage, representing expression noise. By default,
the value stored in the \code{coverageCutoff} slot of the supplied
\code{TranscriptionDataSet} object is used. The optimal cutoff value can
be calculated by \code{\link{estimateBackground}} function call.}

\item{gap.dist}{\code{Numeric}. Maximum allowed distance between transcribed
regions to be merged into the one transcript. By default, the value
stored in the \code{gapDistanceTest} slot of the supplied
\code{TranscriptionDataSet} object is used. The optimal gap distance can
be calculated by \code{\link{estimateGapDistance}} function call.}

\item{estimate.params}{\code{Logical}. Whether to estimate expression level
and coverage density of the detected transcripts. Default: TRUE.}

\item{total.reads}{\code{Numeric}. Total number of reads used for the
normalization, when calculating FPKM. By default, the total number of
reads stored in the provided
\code{\link{TranscriptionDataSet}} object is used.}

\item{combine.by.annot}{\code{Logical}. Whether to combine transcripts
overlapping the same reference annotation. Default: FALSE.}

\item{annot}{\code{\link[GenomicRanges]{GRanges}}. Reference annotations.}
}
\value{
The slot \code{transcripts} of the provided
    \code{TranscriptionDataSet} object will be updated by the
    \code{\link[GenomicRanges]{GRanges}} object, containing detected
    transcripts and, if estimated, corresponding expression levels.
}
\description{
The function dissects transcribed regions (transcripts) genome-wide and
performs expression level quantification.
}
\details{
The function uses two parameters to identify transcribed regions:
    \code{coverage.cutoff} and \code{gap.dist} as calculated by the
    \code{\link{estimateBackground}} and \code{\link{estimateGapDistance}},
    respectively and stored in the \code{\link{TranscriptionDataSet}} object.
    Alternatively, the user may specify his/her own values to be passed to
    the function. By increasing the \code{gap.dist}, fewer transcripts of
    longer size will be identified, and an increase in the \code{coverage.cutoff}
    will result in fewer transcripts of shorter size (a typical transcript tends
    to have a lower fragments coverage at the 3' end, and thus, the
    \code{coverage.cutoff} value will have an impact on the resulting length of
    the detected transcript).

    If \code{estimate.params} is set TRUE, the following metrics are estimated for
    each transcript:
        \itemize{
            \item \code{length} - transcript length (in base pairs).
            \item \code{bases.covered} - the number of bases covered by the
                  sequencing fragments.
            \item \code{coverage} - the proportion of transcript length covered by
                  fragments. Value in the range (0, 1].
            \item \code{fragments} - total number of fragments per transcript.
            \item \code{fpkm} - Fragments Per Kilobase of transcript per Million
                  mapped reads.
            }

    The \code{coverage} is a measure of how densely the transcript is covered by
    the sequencing fragments. Modestly/highly expressed transcripts will have
    a value close to 1, whereas lowly expressed transcripts will have a
    value close to 0, indicating the sparse distribution of sequencing
    fragments along the transcript body.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Load reference annotations (knownGene from UCSC)
data(annot)

### Detect transcripts
detectTranscripts(object = tds, coverage.cutoff = 5, gap.dist = 4000,
estimate.params = TRUE, combine.by.annot = FALSE, annot = annot)

### View detected transcripts
getTranscripts(tds)

}
\seealso{
\code{\link{constructTDS}}
}
\author{
Armen R. Karapetyan
}
