% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr.R
\name{fdr}
\alias{fdr}
\title{Calculate false discovery rate (FDR) on a tree structure}
\usage{
fdr(tree, truth, found, only.leaf = TRUE)
}
\arguments{
\item{tree}{A \code{phylo} object.}

\item{truth}{True signal nodes (e.g., nodes that are truly differentially
abundant between experimental conditions). \strong{Note:} when the
FDR is requested at the leaf level (\code{only.leaf = TRUE}), the
descendant leaves of the given nodes will be found and the FDR will be
estimated on the leaf level.}

\item{found}{Detected signal nodes (e.g., nodes that have been found to be
differentially abundant via a statistical testing procedure).
\strong{Note:} when the FDR is requested at the leaf level
(\code{only.leaf = TRUE}), the descendant leaves of the given nodes will
be found out and the FDR will be estimated on the leaf level.}

\item{only.leaf}{A logical scalar. If \code{TRUE}, the false discovery rate
is calculated at the leaf (tip) level; otherwise it is calculated at
the node level.}
}
\value{
The estimated false discovery rate.
}
\description{
Calculate the false discovery rate on a tree structure, at either leaf or
node level.
}
\examples{
suppressPackageStartupMessages({
    library(ggtree)
    library(TreeSummarizedExperiment)
})

data(tinyTree)

## Two branches are truly differential
ggtree(tinyTree, branch.length = "none") +
   geom_text2(aes(label = node)) +
   geom_hilight(node = 16, fill = "orange", alpha = 0.3) +
   geom_hilight(node = 13, fill = "blue", alpha = 0.3)

## FDR at the leaf level if nodes 14 and 15 are called differential (1/8)
fdr(tree = tinyTree, truth = c(16, 13),
    found = c(15, 14), only.leaf = TRUE)

## FDR at the node level if nodes 14 and 15 are called differential (2/14)
fdr(tree = tinyTree, truth = c(16, 13),
    found = c(15, 14), only.leaf = FALSE)

}
\author{
Ruizhu Huang
}
