% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_findChild.R
\name{findChild}
\alias{findChild}
\title{Find the children of an internal node in a tree}
\usage{
findChild(tree, node, use.alias = FALSE)
}
\arguments{
\item{tree}{A \code{phylo} object.}

\item{node}{Either the node number or node label of an internal node of
\code{tree}.}

\item{use.alias}{A logical scalar. If \code{FALSE} (default), the node label
is used to name the output; otherwise, the alias of the node label is
used. The alias of the node label is created by adding a prefix
\code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
    vector name is the corresponding node label. If a node has no label, it
    would have NA as name when \code{use.alias = FALSE}, and have the alias
    of the node label as name when \code{use.alias = TRUE}.
}
\description{
Find the direct children of an internal node in a tree.
}
\examples{
suppressPackageStartupMessages({
    library(ggtree)
    library(TreeSummarizedExperiment)
})

data(tinyTree)
ggtree(tinyTree, branch.length = "none") +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7) +
    geom_text2(aes(label = label), color = "darkorange",
               hjust = -0.1, vjust = -0.7)

## Specify node numbers
findChild(tree = tinyTree, node = c(17, 12))

## Name return values using aliases
findChild(tree = tinyTree, node = c(17, 12), use.alias = TRUE)

## Specify node labels
findChild(tree = tinyTree, node = c("Node_17", "Node_12"))

## Tips have no children
findChild(tree = tinyTree, node = "t4")

}
\author{
Ruizhu Huang, Charlotte Soneson
}
