% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{fullCopiesSummary}
\alias{fullCopiesSummary}
\title{Get all of the counts data in a summarised data frame.}
\usage{
fullCopiesSummary(df, extraCols = NULL)
}
\arguments{
\item{df}{A data frame generated by \code{\link{fullCountsSummary}}.}

\item{extraCols}{A vector of column names from \code{df} to include. If
\code{NULL}, no extra columns are added. Defaults to \code{NULL}.}
}
\value{
A data frame with the basic figures, the mutant counts, the wild
type counts, the summarised counts, and extraCols if specified. Prints an
additional column for notes, indicating whether this run failed or if there
were fewer than 8000 accepted droplets.
}
\description{
Returns a data frame with all the copies information, plus any optional
columns. This function is intended to be used as a final summary of the
molecule counts.
}
\examples{
df <- fullCountsSummary(KRAScountsQS)
fullCopiesSummary(df)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
