% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansClassify.R
\name{kmeansClassify}
\alias{kmeansClassify}
\alias{kmeansClassify,data.frame-method}
\alias{kmeansClassify,ddpcrWell-method}
\alias{kmeansClassify,ddpcrPlate-method}
\title{K-means classify the wells in a \code{ddpcrWell} or
\code{ddpcrPlate} object, or in a data frame.}
\usage{
kmeansClassify(
  droplets,
  centres = matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol = 2, byrow = TRUE),
  ...
)

\S4method{kmeansClassify}{data.frame}(
  droplets,
  centres = matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol = 2, byrow = TRUE),
  fullTable = TRUE
)

\S4method{kmeansClassify}{ddpcrWell}(
  droplets,
  centres = matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol = 2, byrow = TRUE)
)

\S4method{kmeansClassify}{ddpcrPlate}(
  droplets,
  centres = matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol = 2, byrow = TRUE)
)
}
\arguments{
\item{droplets}{A \code{\link{ddpcrWell}} or \code{\link{ddpcrPlate}}
object, or a data frame with columns \code{Ch1.Amplitude} and
\code{Ch2.Amplitude}.}

\item{centres}{Either:
\itemize{
  \item A matrix corresponding to the initial centres to use for the k-means
  algorithm; or
  \item An integer corresponding to the number of clusters. If this is set,
  the initial centres are randomly set.
}
Defaults to \code{matrix(c(0, 0, 10000, 0, 0, 7000, 10000, 7000), ncol=2,
byrow=TRUE)}}

\item{...}{Other options depending on the type of \code{droplets}.}

\item{fullTable}{If \code{TRUE}, returns a full data frame of droplets and
their classification; if \code{FALSE}, simply returns a factor corresponding
to this classification. Defaults to \code{TRUE}.}
}
\value{
An object with the new classification.

If \code{droplets} is a data frame, a list is returned with the
following components:
  \item{data}{A data frame or vector corresponding to the classification.}
  \item{centres}{A data frame listing the final centre points from the
  k-means algorithm with the corresponding cluster labels.}
}
\description{
If \code{droplets} is a data frame, the droplets are classified
using the k-means clustering algorithm.

For \code{ddpcrWell}, the droplets are classified by using the
k-means clustering algorithm.

For \code{ddpcrPlate}, all of the wells are combined and
classified, with this new classification assigned to the
\code{ddpcrPlate} object.
}
\examples{
### Use the KRASdata dataset for all of these examples.

## Use K-means clustering to classify droplets into four (the default
## number) classes.
aWell <- kmeansClassify(KRASdata[["E03"]])

## We can look the the classification or the centres.
head(aWell$data)
aWell$centres

## Specify 3 centres for a different sample in KRASdata.
aWell <- kmeansClassify(KRASdata[["H04"]], centres=3)
head(aWell$data)

## We can be more specific with the choice of centres.
aWell <- kmeansClassify(KRASdata[["H04"]],
                       centres=matrix(c(5000, 1500, 5500, 7000, 10000,
                                        2000), ncol=2, byrow=TRUE))

## We can use \code{ddpcrWell} objects directly as a parameter.
aWell <- ddpcrWell(well=KRASdata[["E03"]])
kmeansClassify(aWell)

## We can take multiple samples in a \code{ddpcrPlate} object and
## classify everything together.
krasPlate <- ddpcrPlate(wells=KRASdata)
kmeansClassify(krasPlate)

}
\seealso{
This method uses the \code{\link[stats]{kmeans}} function.

To manually set and retrieve classifications, use the
\code{\link{wellClassification}}, \code{\link{plateClassification}} and
\code{\link{plateClassificationMethod}} methods.

For a supervised classification approach, one may want to consider
\code{\link{knnClassify}}.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
