% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddpcrPlate.R
\name{plateClassification}
\alias{plateClassification}
\alias{plateClassification,ddpcrPlate-method}
\alias{plateClassification<-}
\alias{plateClassification<-,ddpcrPlate,character,list-method}
\alias{plateClassification<-,ddpcrPlate,character,factor-method}
\title{Set and retrieve classifications for multiple wells.}
\usage{
plateClassification(
  theObject,
  cMethod = NULL,
  withAmplitudes = FALSE,
  wellCol = FALSE
)

\S4method{plateClassification}{ddpcrPlate}(
  theObject,
  cMethod = NULL,
  withAmplitudes = FALSE,
  wellCol = FALSE
)

plateClassification(theObject, cMethod) <- value

\S4method{plateClassification}{ddpcrPlate,character,list}(theObject, cMethod) <- value

\S4method{plateClassification}{ddpcrPlate,character,factor}(theObject, cMethod) <- value
}
\arguments{
\item{theObject}{A \code{\link{ddpcrPlate}} object.}

\item{cMethod}{This is the name of the classification to retrieve and should
be a character vector. If \code{NULL}, then all of the classifications are
obtained. Defaults to \code{NULL}.}

\item{withAmplitudes}{If \code{TRUE}, the droplet amplitudes are included.
Defaults to \code{FALSE}.}

\item{wellCol}{If \code{TRUE}, an additional column is included in the
output, where each entry is the name of the well from which the droplet
originated. In this case, this setting forces the \code{withAmplitudes}
parameter to \code{TRUE}. Defaults to \code{FALSE}.}

\item{value}{Either:
\itemize{
  \item A list of factors, where each item of the list corresponds to
  a well;
  \item A single factor corresponding to all of the wells combined. This
  should be ordered by the order of the output of the
  \code{\link{amplitudes}} function when the rows of the data frames have
  been bound together, i.e. with \code{do.call(rbind,
  amplitudes(theObject))}.
}}
}
\value{
If requesting one classification without the amplitudes, a list of
factors corresponding to the classifications is returned. Otherwise, a list
of data frames is returned where each row corresponds to a droplet in the
corresponding well.
}
\description{
Retrieve multiple classification factors that have been assigned to
a \code{ddpcrPlate} object.
}
\examples{
### The examples here show how this method works by setting classifications
### using data frames. To do this, we use the
### \code{\link{thresholdClassify}} method on _data frames_. Note that
### \code{thresholdClassify} also works directly on \code{ddpcrWell} and
### \code{ddpcrPlate} objects; this is simply an illustration of
### how to use the \code{plateClassification} method directly. In general,
### it is recommended to use \code{thresholdClassify} directly on
### \code{ddpcrPlate} objects.

## Create a ddpcrPlate object.
krasPlate <- ddpcrPlate(wells=KRASdata)

## Classify a data frame of droplets and keep it in a _single_ data frame.
## Set the new classification from this.
droplets <- do.call(rbind, amplitudes(krasPlate))
clSingle <- thresholdClassify(droplets,
                              ch1Threshold=7000, ch2Threshold=3500,
                              fullTable=FALSE)
plateClassification(krasPlate, "thresholdSing") <- clSingle

## We can also set the new classification from a list of factors.
clList <- lapply(KRASdata, thresholdClassify, ch1Threshold=7000,
                 ch2Threshold=3500, fullTable=FALSE)
plateClassification(krasPlate, "thresholdList") <- clList

## We can get all of the classifications as a list of data frames.
plate <- plateClassification(krasPlate)
lapply(plate, head, n=1)

## We can include the droplet amplitudes columns.
plate <- plateClassification(krasPlate, withAmplitudes=TRUE)
lapply(plate, head, n=1)

## We can focus on specific classifications.
plate <- plateClassification(krasPlate, cMethod=c("thresholdSing",
                                                  "thresholdList"))
lapply(plate, head, n=1)

## The wellCol option adds an extra column showing which well the droplet
## came from.
plate <- plateClassification(krasPlate, withAmplitudes=TRUE, wellCol=TRUE)
lapply(plate, head, n=1)


}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
