% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSort_sorting_wrapper.R
\name{uSORT_sorting_wrapper}
\alias{uSORT_sorting_wrapper}
\title{wrapper of all avaliable sorting methods in uSORT}
\usage{
uSORT_sorting_wrapper(data, data_raw, method = c("autoSPIN", "sWanderlust",
  "monocle", "Wanderlust", "SPIN", "none"), data_type = c("linear",
  "cyclical"), SPIN_option = c("STS", "neighborhood"), SPIN_sigma_width = 1,
  autoSPIN_alpha = 0.2, autoSPIN_randomization = 20,
  wanderlust_start_cell = NULL, wanderlust_dfmap_components = 4,
  wanderlust_l = 15, wanderlust_num_waypoints = 150,
  wanderlust_waypoints_seed = 2711, wanderlust_flock_waypoints = 2)
}
\arguments{
\item{data}{Input preprocessed data matrix with row.name of cells and col.name of genes.}

\item{data_raw}{Input raw data matrix with row.name of cells and col.name of genes, for monocle method.}

\item{method}{The name of the sorting method to use, including \code{autoSPIN}, \code{sWanderlust}, \code{monocle}, \code{Wanderlust}, \code{SPIN} and \code{none}.}

\item{data_type}{The type of the data, either \code{linear} or \code{cyclical}.}

\item{SPIN_option}{The runing option of SPIN, \code{STS} or \code{neighborhood}.}

\item{SPIN_sigma_width}{Sigma width for SPIN.}

\item{autoSPIN_alpha}{alpha for autoSPIN.}

\item{autoSPIN_randomization}{Number of randomization for autoSPIN.}

\item{wanderlust_start_cell}{The id of the starting cell for wanderlust.}

\item{wanderlust_dfmap_components}{The number of components from diffusionmap for wanderlust.}

\item{wanderlust_l}{The number of nearest neighbors used for wanderlust.}

\item{wanderlust_num_waypoints}{The number of waypoints for wanderlust.}

\item{wanderlust_waypoints_seed}{The seed for reproducible analysis.}

\item{wanderlust_flock_waypoints}{The bumber of flock times for wanderlust.}
}
\value{
return the order of sorting results.
}
\description{
Sorting methods include \code{autoSPIN}, \code{sWanderlust}, \code{monocle},
\code{Wanderlust}, \code{SPIN}. Any of the sorting method can be called directly
using this funciton.
}
\examples{
dir <- system.file('extdata', package='uSORT')
file <- list.files(dir, pattern='.txt$', full=TRUE)
exprs <- uSORT_preProcess(exprs_file = file)
exp_trimmed <- t(exprs$exprs_log_trimed)
PCA_selected_genes <- pca_gene_selection(exp_trimmed)
exp_PCA_genes <- exp_trimmed[, PCA_selected_genes]
#order <- uSORT_sorting_wrapper(data = exp_PCA_genes, method = 'autoSPIN')
}

