% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordFrequencies.R
\name{computeMsigWordFreq}
\alias{computeMsigWordFreq}
\title{Compute word frequencies for a single MSigDB collection}
\usage{
computeMsigWordFreq(
  msigGsc,
  weight = NULL,
  measure = c("tfidf", "tf"),
  version = msigdb::getMsigdbVersions(),
  org = c("auto", "hs", "mm"),
  rmwords = getMsigExclusionList(),
  idf = NULL
)
}
\arguments{
\item{msigGsc}{a GeneSetCollection object, containing gene sets from the
MSigDB. The \code{\link[GSEABase:getObjects]{GSEABase::getBroadSets()}} function can be used to parse XML
files downloaded from MSigDB.}

\item{weight}{a named numeric vector, containing weights to apply to each
gene-set. This can be -log10(FDR), -log10(p-value) or an enrichment score
(ideally unsigned).}

\item{measure}{a character, specifying how frequencies should be computed.
"tf" uses term frequencies and "tfidf" (default) applies inverse document
frequency weights to term frequencies.}

\item{version}{a character, specifying the version of msigdb to use (see
\code{msigdb::getMsigdbVersions()}).}

\item{org}{a character, specifying the organism to use. This can either be
"auto" (default), "hs" or "mm".}

\item{rmwords}{a character vector, containing an exclusion list of words to discard
from the analysis.}

\item{idf}{a list of named numeric vectors, specifying inverse document frequencies to use to penalise terms from gene-set names and short descriptions. This should be a vector of length 2 with names "Name" and "Short". Numeric vectors should contain weights and names should represent the term. Precomputed versions can be retrieved using the \code{\link[msigdb:getMsigdbIDF]{msigdb::getMsigdbIDF()}}.}
}
\value{
a list, containing two data.frames summarising the results of the
frequency analysis on gene set names and short descriptions.
}
\description{
Compute word frequencies for a single MSigDB collection
}
\examples{
data(hgsc)
freq <- computeMsigWordFreq(hgsc, measure = 'tfidf')

}
