% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{plot_gsea}
\alias{plot_gsea}
\title{Plot GSEA results}
\usage{
plot_gsea(
  gsea.obj,
  twoColors = c("red", "blue"),
  plotNames = FALSE,
  colBarcode = "black",
  title = "Running Enrichment Score",
  bottomYtitle = "List Values",
  bottomYlabel = "Signature values",
  ext_nes = NULL,
  omit_middle = FALSE
)
}
\arguments{
\item{gsea.obj}{GSEA object produced by the \code{gsea} function}

\item{twoColors}{the two colors to use for positive[1] and negative[2]
enrichment scores}

\item{plotNames}{Logical. Should the set names be plotted?}

\item{colBarcode}{The color of the barcode}

\item{title}{String to be plotted above the Running Enrichment Score}

\item{bottomYtitle}{String for the title of the bottom part of the plot}

\item{bottomYlabel}{String for the label}

\item{ext_nes}{Provide a NES from an external calculation}

\item{omit_middle}{If TRUE, will not plot the running score
(FALSE by default)}
}
\value{
Nothing, a plot is generated in the default output device
}
\description{
This function generates a GSEA plot from a gsea object
}
\examples{
reflist<-setNames(-sort(rnorm(26)),LETTERS)
set<-c('A','B','D','F')
obj<-gsea(reflist,set,method='pareto')
plot_gsea(obj)
}
