% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{graph_from_op}
\alias{graph_from_op}
\title{Igraph object from OmniPath network}
\usage{
graph_from_op(op_data)
}
\arguments{
\item{op_data}{Data frame (tibble) of OmniPath PPI interactions from
\code{\link{wppi_omnipath_data}}.}
}
\value{
Igraph PPI graph object with vertices defined by UniProt ID and
    Gene Symbol, and edges based on interactions, for all connections in
    OmniPath.
}
\description{
Creation of igraph object from PPI OmniPath database with information
regarding proteins and gene symbols.
}
\examples{
graph_op <- graph_from_op(wppi_omnipath_data())
edges_op <- igraph::E(graph_op)
vertices_op <- igraph::V(graph_op)

}
\seealso{
\code{\link{wppi_omnipath_data}}
}
