% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{subgraph_op}
\alias{subgraph_op}
\title{Extract PPI subgraph by genes of interest}
\usage{
subgraph_op(graph_op, gene_set, sub_level = 1L)
}
\arguments{
\item{graph_op}{Igraph object based on OmniPath PPI interactions from
\code{\link{graph_from_op}}.}

\item{gene_set}{Character vector of gene symbols. These are the genes of
interest, for example known disease specific genes.}

\item{sub_level}{Integer larger than 0 defining the order of neighborhood
(number of steps) from the genes of interest. If not specified, the
first-order neighbors are used.}
}
\value{
Igraph graph object with PPI network of given genes of interest
    and their x-order degree neighbors.
}
\description{
From the igraph object of a PPI network obtained from OmniPath extracts a
subnetwork around the provided genes of interest. The size of the graph
is determined by the \code{sub_level} parameter, i.e. the maximum number
of steps (order) from the genes of interest.
}
\examples{
# Subgraphs of first and second order
graph_op <- graph_from_op(wppi_omnipath_data())
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
graph_op_2 <- subgraph_op(graph_op, genes_interest, 2)

}
