% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/methods-OnDiskMSnExp.R
\name{findChromPeaksIsolationWindow}
\alias{findChromPeaksIsolationWindow}
\alias{findChromPeaksIsolationWindow,MsExperiment-method}
\alias{findChromPeaksIsolationWindow,OnDiskMSnExp-method}
\title{Data independent acquisition (DIA): peak detection in isolation windows}
\usage{
findChromPeaksIsolationWindow(object, ...)

\S4method{findChromPeaksIsolationWindow}{MsExperiment}(
  object,
  param,
  msLevel = 2L,
  isolationWindow = isolationWindowTargetMz(spectra(object)),
  chunkSize = 2L,
  ...,
  BPPARAM = bpparam()
)

\S4method{findChromPeaksIsolationWindow}{OnDiskMSnExp}(
  object,
  param,
  msLevel = 2L,
  isolationWindow = isolationWindowTargetMz(object),
  ...
)
}
\arguments{
\item{object}{\code{MsExperiment}, \code{XcmsExperiment}, \code{OnDiskMSnExp} or \code{XCMSnExp}
object with the DIA data.}

\item{...}{currently not used.}

\item{param}{Peak detection parameter object, such as a
\linkS4class{CentWaveParam} object defining and configuring the chromographic
peak detection algorithm.
See also \code{\link[=findChromPeaks]{findChromPeaks()}} for more details.}

\item{msLevel}{\code{integer(1)} specifying the MS level in which the peak
detection should be performed. By default \code{msLevel = 2L}.}

\item{isolationWindow}{\code{factor} or similar defining the isolation windows in
which the peak detection should be performed with length equal to the
number of spectra in \code{object}.}

\item{chunkSize}{if \code{object} is an \code{MsExperiment} or \code{XcmsExperiment}:
\code{integer(1)} defining the number of files (samples) that should be
loaded into memory and processed at a time. See \code{\link[=findChromPeaks]{findChromPeaks()}} for
more information.}

\item{BPPARAM}{if \code{object} is an \code{MsExperiment} or \code{XcmsExperiment}:
parallel processing setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more
information.}
}
\value{
An \code{XcmsExperiment} or \code{XCMSnExp} object with the chromatographic peaks
identified in spectra of each isolation window from each file added to the
\code{chromPeaks} matrix.
Isolation window definition for each identified peak are stored as additional
columns in \code{\link[=chromPeakData]{chromPeakData()}}.
}
\description{
The \code{findChromPeaksIsolationWindow} function allows to perform a
chromatographic peak detection in MS level > 1 spectra of certain isolation
windows (e.g. SWATH pockets). The function performs a peak detection,
separately for all spectra belonging to the same isolation window and adds
them to the \code{\link[=chromPeaks]{chromPeaks()}} matrix of the result object. Information about
the isolation window in which they were detected is added to
\code{\link[=chromPeakData]{chromPeakData()}} data frame.

Note that peak detection with this method does not remove previously
identified chromatographic peaks (e.g. on MS1 level using the
\code{\link[=findChromPeaks]{findChromPeaks()}} function but adds newly identified peaks to the existing
\code{\link[=chromPeaks]{chromPeaks()}} matrix.

Isolation windows can be defined with the \code{isolationWindow} parameter, that
by default uses the definition of \code{\link[=isolationWindowTargetMz]{isolationWindowTargetMz()}}, i.e.
chromatographic peak detection is performed for all spectra with the same
isolation window target m/z (seprarately for each file). The parameter
\code{param} allows to define and configure the peak detection algorithm (see
\code{\link[=findChromPeaks]{findChromPeaks()}} for more information).
}
\seealso{
\code{\link[=reconstructChromPeakSpectra]{reconstructChromPeakSpectra()}} for the function to reconstruct
MS2 spectra for each MS1 chromatographic peak.
}
\author{
Johannes Rainer, Michael Witting
}
