% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{addSignatures}
\alias{addSignatures}
\title{Add molecular signatures to MultiAssayExperiment}
\usage{
addSignatures(mae, ..., intersect_rows = TRUE)
}
\arguments{
\item{mae}{MultiAssayExperiment object.}

\item{...}{named experiments to be added to \code{mae}.}

\item{intersect_rows}{logical flag indicating if only common rows across
experiments should be included. Only set to \code{FALSE} if you know what
you are doing.}
}
\value{
MultiAssayExperiment object with new experiments added.
}
\description{
\code{addSignatures} extends \code{mae} by adding to it new experiments.
Rows consistency is ensured by taking an intersection of rows after new
experiments are added.
}
\examples{
data("rinderpest_mini", "remap_mini")
base_lvl <- "00hr"
design <- matrix(
  data = c(1, 0, 0,
           1, 0, 0,
           1, 0, 0,
           0, 1, 0,
           0, 1, 0,
           0, 1, 0,
           0, 0, 1,
           0, 0, 1,
           0, 0, 1),
  ncol = 3,
  nrow = 9,
  byrow = TRUE,
  dimnames = list(colnames(rinderpest_mini), c("00hr", "12hr", "24hr")))
mae <- prepareCountsForRegression(
  counts = rinderpest_mini,
  design = design,
  base_lvl = base_lvl)
mae <- addSignatures(mae, remap = remap_mini)

}
