datacache <- new.env(hash=TRUE, parent=emptyenv())

drosgenome1 <- function() showQCData("drosgenome1", datacache)
drosgenome1_dbconn <- function() dbconn(datacache)
drosgenome1_dbfile <- function() dbfile(datacache)
drosgenome1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
drosgenome1_dbInfo <- function() dbInfo(datacache)

drosgenome1ORGANISM <- "Drosophila melanogaster"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "drosgenome1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("FLYCHIP_DB", "drosgenome1", "chip drosgenome1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("drosgenome1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(drosgenome1_dbconn())
}

