\name{org.Dm.egFLYBASE}
\alias{org.Dm.egFLYBASE}
\alias{org.Dm.egFLYBASE2EG}
\title{Map FlyBase acession numbers with Entrez Gene identifiers}  
\description{ 
  org.Dm.egFLYBASE is an R object that contains mappings between 
  Entrez Gene identifiers and FlyBase accession numbers.    
}
\details{
  This object is a simple mapping of Entrez Gene identifiers
  \url{https://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene} to Flybase
  accession numbers.

  Mappings were based on data provided by: Entrez Gene  
  ftp://ftp.ncbi.nlm.nih.gov/gene/DATA  
  With a date stamp from the source of: 2025-Sep24
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
x <- org.Dm.egFLYBASE
# Get the entrez gene identifiers that are mapped to a Flybase ID
mapped_genes <- mappedkeys(x)
# Convert to a list
xx <- as.list(x[mapped_genes])
if(length(xx) > 0) {
  # Get the FlyBase IDs for the first five genes
  xx[1:5]
  # Get the first one
  xx[[1]]
}
#For the reverse map FLYBASE2EG:
# Convert to a list
xx <- as.list(org.Dm.egFLYBASE2EG)
if(length(xx) > 0){
   # Gets the entrez gene identifiers for the first five FlyBase IDs
   xx[1:5]
   # Get the first one
   xx[[1]]
}
}
\keyword{datasets}



