% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryEngine.R
\name{fetch_data_precomp}
\alias{fetch_data_precomp}
\title{Fetch data from the CENTREprecompDb database}
\usage{
fetch_data_precomp(x, table, columns, entries, column_filter)
}
\arguments{
\item{x}{\code{CENTREprecompDb} object.}

\item{table}{Table of the database on which to search.
Can be combinedTestData or cor_CRUP.}

\item{columns}{Columns to select. Equivalent to X in SELECT X.}

\item{entries}{Element ID to select. Equivalen to ID in SELECT X FROM TABLE
WHERE ID in Z. If entries or column_filter is missing the program assumes the
query is SELECT X FROM TABLE.}

\item{column_filter}{Column on which to apply filter. Equivalent to Z in
SELECT X FROM TABLE WHERE ID in Z. If entries or column_filter is missing the
program assumes the query is SELECT X FROM TABLE.}
}
\value{
data.frame with the data queried.
}
\description{
Function to fetch data from the CENTREprecomputed package database
through the \code{CENTREprecompDb} object.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
centreprecompdb <- eh[["EH9540"]]

res <- fetch_data_precomp(centreprecompdb,
    table = "crup_cor",
    columns = c("pair", "cor_CRUP"),
    entries = "EH38E3440167",
    column_filter = "symbol38"
)
}
\references{
Based on the package CompoundDb query engine internal functions.
}
\seealso{
\code{vignette("CENTREprecomputed")}
}
