% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_methods.R
\name{continuous_wrap}
\alias{continuous_wrap}
\title{Benchmarking wrapper: Given a multiple testing method, convert it so that it takes
  a simulation object (see simulation function) and a nominal level alpha
  as inputs}
\usage{
continuous_wrap(mt_method, nbins = 20)
}
\arguments{
\item{mt_method}{Multiple testing method (e.g. a function such as gbh or ddhf)}

\item{nbins}{Integer, number of equally sized bins into which to stratify hypotheses}
}
\value{
A new multiple testing function which has an
          interface of the form f(sim_data_frame, alpha)
}
\description{
Benchmarking wrapper: Given a multiple testing method, convert it so that it takes
  a simulation object (see simulation function) and a nominal level alpha
  as inputs
}
\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     sim_df$group <- groups_by_filter(sim_df$filterstat, 20)
     obj <- tst_gbh(sim_df$pvalue, sim_df$group, .1)
     sum(rejected_hypotheses(obj))

     tst_gbh_continuous <- continuous_wrap(tst_gbh)
     obj2 <- tst_gbh_continuous(sim_df, .1)
     sum(rejected_hypotheses(obj2))

}
