% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_target.R
\name{bam_reheader_R}
\alias{bam_reheader_R}
\title{Replace the header from a .bam file}
\usage{
bam_reheader_R(
  head,
  old_bam,
  new_bam = paste(tools::file_path_sans_ext(old_bam), "h.bam", sep = "")
)
}
\arguments{
\item{head}{A file name and location for the .sam file with the new header.}

\item{old_bam}{A file name and location for the .bam file which you would}

\item{new_bam}{A file name for the new .bam file with a replaced header.
Defaults to the same base filename plus 'h.bam'. For example, 'example.bam'
will be written as 'exampleh.bam'.}
}
\value{
This function will return a new .bam file with a replaced header. The
function also outputs the new .bam filename.
}
\description{
This function replaces the header from one .bam file with a header from a
different .sam file. This function mimics the function of the 'reheader'
function in samtools. It is not intended for use by users.
}
