% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_blast.R
\name{blast_result_metrics}
\alias{blast_result_metrics}
\title{Calculates result metrics from a blast results table}
\usage{
blast_result_metrics(blast_results_table_path, accession_path, db = NULL)
}
\arguments{
\item{blast_results_table_path}{path for blast results csv file}

\item{accession_path}{(character) Filepath to NCBI accessions SQL
database. See \code{taxonomzr::prepareDatabase()}.}

\item{db}{Currently accepts one of \code{c("ncbi", "silva", "other")} Default
is \code{"ncbi"}, appropriate for samples aligned against indices compiled
from NCBI whole genome databases. Alternatively, usage of an alternate
database (like Greengenes2) should be specified with \code{"other"}.}
}
\value{
a vector with best_hit, uniqueness_score, species_percentage_hit
  genus_percentage_hit, species_contaminant_score, and
  genus_contaminant_score
}
\description{
This function calculates the best hit (genome with most blast read hits),
uniqueness score (total number of genomes hit), species percentage hit
(percentage of reads where MetaScope species also matched the blast hit
species), genus percentage hit (percentage of reads where blast genus matched
MetaScope aligned genus) and species contaminant score (percentage of reads
that blasted to other species genomes) and genus contaminant score
(percentage of reads that blasted to other genus genomes)
}
