/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.base;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryConnectionWrapper;
import org.openrdf.repository.event.InterceptingRepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionInterceptor;

public class InterceptingRepositoryConnectionWrapper
extends RepositoryConnectionWrapper
implements InterceptingRepositoryConnection {
    private boolean activated;
    private Set<RepositoryConnectionInterceptor> interceptors = new CopyOnWriteArraySet<RepositoryConnectionInterceptor>();

    public InterceptingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    @Override
    public void addRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.activated = true;
    }

    @Override
    public void removeRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.activated = !this.interceptors.isEmpty();
    }

    @Override
    protected boolean isDelegatingAdd() {
        return !this.activated;
    }

    @Override
    protected boolean isDelegatingRemove() {
        return !this.activated;
    }

    @Override
    public void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).add(this.getDelegate(), subject, predicate, object, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).clear(this.getDelegate(), contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().clear(contexts);
        }
    }

    @Override
    public void begin() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).begin(this.getDelegate()))) {
            }
        }
        if (!denied) {
            super.begin();
        }
    }

    @Override
    public void close() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).close(this.getDelegate()))) {
            }
        }
        if (!denied) {
            super.close();
        }
    }

    @Override
    public void commit() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).commit(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().commit();
        }
    }

    @Override
    public void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).remove(this.getDelegate(), subject, predicate, object, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).removeNamespace(this.getDelegate(), prefix))) {
            }
        }
        if (!denied) {
            this.getDelegate().removeNamespace(prefix);
        }
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).clearNamespaces(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().clearNamespaces();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).rollback(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().rollback();
        }
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        boolean denied = false;
        boolean wasAutoCommit = this.isAutoCommit();
        if (this.activated && wasAutoCommit != autoCommit) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).setAutoCommit(this.getDelegate(), autoCommit))) {
            }
        }
        if (!denied) {
            this.getDelegate().setAutoCommit(autoCommit);
        }
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).setNamespace(this.getDelegate(), prefix, name))) {
            }
        }
        if (!denied) {
            this.getDelegate().setNamespace(prefix, name);
        }
    }

    @Override
    public Update prepareUpdate(final QueryLanguage ql, final String update, final String baseURI) throws MalformedQueryException, RepositoryException {
        if (this.activated) {
            return new Update(){
                private final RepositoryConnection conn;
                private final Update delegate;
                {
                    this.conn = InterceptingRepositoryConnectionWrapper.this.getDelegate();
                    this.delegate = this.conn.prepareUpdate(ql, update, baseURI);
                }

                @Override
                public void execute() throws UpdateExecutionException {
                    boolean denied = false;
                    if (InterceptingRepositoryConnectionWrapper.this.activated) {
                        RepositoryConnectionInterceptor interceptor;
                        Iterator i$ = InterceptingRepositoryConnectionWrapper.this.interceptors.iterator();
                        while (i$.hasNext() && !(denied = (interceptor = (RepositoryConnectionInterceptor)i$.next()).execute(this.conn, ql, update, baseURI, this.delegate))) {
                        }
                    }
                    if (!denied) {
                        this.delegate.execute();
                    }
                }

                @Override
                public void setBinding(String name, Value value) {
                    this.delegate.setBinding(name, value);
                }

                @Override
                public void removeBinding(String name) {
                    this.delegate.removeBinding(name);
                }

                @Override
                public void clearBindings() {
                    this.delegate.clearBindings();
                }

                @Override
                public BindingSet getBindings() {
                    return this.delegate.getBindings();
                }

                @Override
                public void setDataset(Dataset dataset) {
                    this.delegate.setDataset(dataset);
                }

                @Override
                public Dataset getDataset() {
                    return this.delegate.getDataset();
                }

                @Override
                public void setIncludeInferred(boolean includeInferred) {
                    this.delegate.setIncludeInferred(includeInferred);
                }

                @Override
                public boolean getIncludeInferred() {
                    return this.delegate.getIncludeInferred();
                }
            };
        }
        return this.getDelegate().prepareUpdate(ql, update, baseURI);
    }
}

