/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Add;
import org.openrdf.query.algebra.Clear;
import org.openrdf.query.algebra.Copy;
import org.openrdf.query.algebra.Create;
import org.openrdf.query.algebra.DeleteData;
import org.openrdf.query.algebra.InsertData;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.Move;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.sail.helpers.RDFSailInserter;
import org.openrdf.repository.util.RDFLoader;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UpdateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailUpdateExecutor {
    private final Logger logger = LoggerFactory.getLogger(SailUpdateExecutor.class);
    private final SailConnection con;
    private final ValueFactory vf;
    private final RDFLoader loader;

    public SailUpdateExecutor(SailConnection con, ValueFactory vf, ParserConfig loadConfig) {
        this.con = con;
        this.vf = vf;
        this.loader = new RDFLoader(loadConfig, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException, RDFParseException, IOException {
        UpdateContext uc = new UpdateContext(updateExpr, dataset, bindings, includeInferred);
        this.logger.trace("Incoming update expression:\n{}", (Object)uc);
        this.con.startUpdate(uc);
        try {
            if (updateExpr instanceof Load) {
                this.executeLoad((Load)updateExpr, uc);
            } else if (updateExpr instanceof Modify) {
                this.executeModify((Modify)updateExpr, uc);
            } else if (updateExpr instanceof InsertData) {
                this.executeInsertData((InsertData)updateExpr, uc);
            } else if (updateExpr instanceof DeleteData) {
                this.executeDeleteData((DeleteData)updateExpr, uc);
            } else if (updateExpr instanceof Clear) {
                this.executeClear((Clear)updateExpr, uc);
            } else if (updateExpr instanceof Create) {
                this.executeCreate((Create)updateExpr, uc);
            } else if (updateExpr instanceof Copy) {
                this.executeCopy((Copy)updateExpr, uc);
            } else if (updateExpr instanceof Add) {
                this.executeAdd((Add)updateExpr, uc);
            } else if (updateExpr instanceof Move) {
                this.executeMove((Move)updateExpr, uc);
            } else if (updateExpr instanceof Load) {
                throw new SailException("load operations can not be handled directly by the SAIL");
            }
        }
        finally {
            this.con.endUpdate(uc);
        }
    }

    protected void executeLoad(Load load, UpdateContext uc) throws IOException, RDFParseException, SailException {
        Value source = load.getSource().getValue();
        Value graph = load.getGraph() != null ? load.getGraph().getValue() : null;
        URL sourceURL = new URL(source.stringValue());
        RDFSailInserter rdfInserter = new RDFSailInserter(this.con, this.vf, uc);
        if (graph != null) {
            rdfInserter.enforceContext((Resource)graph);
        }
        try {
            this.loader.load(sourceURL, source.stringValue(), null, (RDFHandler)rdfInserter);
        }
        catch (RDFHandlerException e) {
            throw (SailException)e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCreate(Create create, UpdateContext uc) throws SailException {
        Value graphValue = create.getGraph().getValue();
        if (graphValue instanceof Resource) {
            Resource namedGraph = (Resource)graphValue;
            CloseableIteration<? extends Resource, SailException> contextIDs = this.con.getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    Resource contextID = (Resource)contextIDs.next();
                    if (!namedGraph.equals(contextID)) continue;
                    throw new SailException("Named graph " + namedGraph + " already exists. ");
                }
            }
            finally {
                contextIDs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCopy(Copy copy, UpdateContext uc) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = copy.getSourceGraph();
        ValueConstant destinationGraph = copy.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.con.clear(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAdd(Add add, UpdateContext uc) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = add.getSourceGraph();
        ValueConstant destinationGraph = add.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMove(Move move, UpdateContext uc) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = move.getSourceGraph();
        ValueConstant destinationGraph = move.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.con.clear(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
                this.con.removeStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), source);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeClear(Clear clearExpr, UpdateContext uc) throws SailException {
        block10: {
            try {
                ValueConstant graph = clearExpr.getGraph();
                if (graph != null) {
                    Resource context = (Resource)graph.getValue();
                    this.con.clear(context);
                    break block10;
                }
                StatementPattern.Scope scope = clearExpr.getScope();
                if (StatementPattern.Scope.NAMED_CONTEXTS.equals((Object)scope)) {
                    CloseableIteration<? extends Resource, SailException> contextIDs = this.con.getContextIDs();
                    try {
                        while (contextIDs.hasNext()) {
                            this.con.clear((Resource)contextIDs.next());
                        }
                        break block10;
                    }
                    finally {
                        contextIDs.close();
                    }
                }
                if (StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)scope)) {
                    this.con.clear(new Resource[]{null});
                } else {
                    this.con.clear(new Resource[0]);
                }
            }
            catch (SailException e) {
                if (clearExpr.isSilent()) break block10;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInsertData(InsertData insertDataExpr, UpdateContext uc) throws SailException {
        TupleExpr insertExpr = insertDataExpr.getInsertExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeInserted = this.con.evaluate(insertExpr, uc.getDataset(), uc.getBindingSet(), uc.isIncludeInferred());
        try {
            try {
                URI insert = uc.getDataset().getDefaultInsertGraph();
                while (toBeInserted.hasNext()) {
                    BindingSet bs = (BindingSet)toBeInserted.next();
                    Resource subject = (Resource)bs.getValue("subject");
                    URI predicate = (URI)bs.getValue("predicate");
                    Value object = bs.getValue("object");
                    Resource context = (Resource)bs.getValue("context");
                    if (context == null && insert == null) {
                        this.con.addStatement(uc, subject, predicate, object, new Resource[0]);
                        continue;
                    }
                    if (context == null) {
                        this.con.addStatement(uc, subject, predicate, object, insert);
                        continue;
                    }
                    this.con.addStatement(uc, subject, predicate, object, context);
                }
            }
            finally {
                toBeInserted.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDeleteData(DeleteData deleteDataExpr, UpdateContext uc) throws SailException {
        TupleExpr deleteExpr = deleteDataExpr.getDeleteExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeDeleted = this.con.evaluate(deleteExpr, uc.getDataset(), uc.getBindingSet(), uc.isIncludeInferred());
        try {
            try {
                Resource[] remove = this.getDefaultRemoveGraphs(uc.getDataset());
                while (toBeDeleted.hasNext()) {
                    BindingSet bs = (BindingSet)toBeDeleted.next();
                    Resource subject = (Resource)bs.getValue("subject");
                    URI predicate = (URI)bs.getValue("predicate");
                    Value object = bs.getValue("object");
                    Resource context = (Resource)bs.getValue("context");
                    if (context != null) {
                        this.con.removeStatement(uc, subject, predicate, object, context);
                        continue;
                    }
                    if (remove == null) continue;
                    this.con.removeStatement(uc, subject, predicate, object, remove);
                }
            }
            finally {
                toBeDeleted.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeModify(Modify modify, UpdateContext uc) throws SailException {
        try {
            TupleExpr whereClause = modify.getWhereExpr();
            if (!(whereClause instanceof QueryRoot)) {
                whereClause = new QueryRoot(whereClause);
            }
            CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = this.evaluateWhereClause(whereClause, uc);
            try {
                while (sourceBindings.hasNext()) {
                    BindingSet sourceBinding = (BindingSet)sourceBindings.next();
                    this.deleteBoundTriples(sourceBinding, modify.getDeleteExpr(), uc);
                    this.insertBoundTriples(sourceBinding, modify.getInsertExpr(), uc);
                }
            }
            finally {
                sourceBindings.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    private URI[] getDefaultRemoveGraphs(Dataset dataset) {
        if (dataset == null) {
            return new URI[0];
        }
        Set<URI> set = dataset.getDefaultRemoveGraphs();
        if (set == null || set.isEmpty()) {
            return new URI[0];
        }
        return set.toArray(new URI[set.size()]);
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateWhereClause(final TupleExpr whereClause, final UpdateContext uc) throws SailException, QueryEvaluationException {
        CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = this.con.evaluate(whereClause, uc.getDataset(), uc.getBindingSet(), uc.isIncludeInferred());
        return new ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException>(sourceBindings){

            @Override
            protected BindingSet convert(BindingSet sourceBinding) throws QueryEvaluationException {
                if (whereClause instanceof SingletonSet && sourceBinding instanceof EmptyBindingSet && uc.getBindingSet() != null) {
                    return uc.getBindingSet();
                }
                HashSet<String> uniqueBindings = new HashSet<String>(uc.getBindingSet().getBindingNames());
                uniqueBindings.removeAll(sourceBinding.getBindingNames());
                if (uniqueBindings.size() > 0) {
                    MapBindingSet mergedSet = new MapBindingSet();
                    for (String bindingName : sourceBinding.getBindingNames()) {
                        mergedSet.addBinding(sourceBinding.getBinding(bindingName));
                    }
                    for (String bindingName : uniqueBindings) {
                        mergedSet.addBinding(uc.getBindingSet().getBinding(bindingName));
                    }
                    return mergedSet;
                }
                return sourceBinding;
            }
        };
    }

    private void deleteBoundTriples(BindingSet whereBinding, TupleExpr deleteClause, UpdateContext uc) throws SailException {
        if (deleteClause != null) {
            List<StatementPattern> deletePatterns = StatementPatternCollector.process(deleteClause);
            for (StatementPattern deletePattern : deletePatterns) {
                Resource subject = (Resource)this.getValueForVar(deletePattern.getSubjectVar(), whereBinding);
                URI predicate = (URI)this.getValueForVar(deletePattern.getPredicateVar(), whereBinding);
                Value object = this.getValueForVar(deletePattern.getObjectVar(), whereBinding);
                Resource context = null;
                if (deletePattern.getContextVar() != null) {
                    context = (Resource)this.getValueForVar(deletePattern.getContextVar(), whereBinding);
                }
                if (subject == null || predicate == null || object == null) continue;
                if (context != null) {
                    this.con.removeStatement(uc, subject, predicate, object, context);
                    continue;
                }
                Resource[] remove = this.getDefaultRemoveGraphs(uc.getDataset());
                this.con.removeStatement(uc, subject, predicate, object, remove);
            }
        }
    }

    private void insertBoundTriples(BindingSet whereBinding, TupleExpr insertClause, UpdateContext uc) throws SailException {
        if (insertClause != null) {
            List<StatementPattern> insertPatterns = StatementPatternCollector.process(insertClause);
            MapBindingSet bnodeMapping = new MapBindingSet();
            for (StatementPattern insertPattern : insertPatterns) {
                Statement toBeInserted = this.createStatementFromPattern(insertPattern, whereBinding, bnodeMapping);
                if (toBeInserted == null) continue;
                URI with = uc.getDataset().getDefaultInsertGraph();
                if (with == null && toBeInserted.getContext() == null) {
                    this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), new Resource[0]);
                    continue;
                }
                if (toBeInserted.getContext() == null) {
                    this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), with);
                    continue;
                }
                this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), toBeInserted.getContext());
            }
        }
    }

    private Statement createStatementFromPattern(StatementPattern pattern, BindingSet sourceBinding, MapBindingSet bnodeMapping) throws SailException {
        Resource subject = null;
        URI predicate = null;
        Value object = null;
        Resource context = null;
        if (pattern.getSubjectVar().hasValue()) {
            subject = (Resource)pattern.getSubjectVar().getValue();
        } else {
            subject = (Resource)sourceBinding.getValue(pattern.getSubjectVar().getName());
            if (subject == null && pattern.getSubjectVar().isAnonymous()) {
                Binding mappedSubject = bnodeMapping.getBinding(pattern.getSubjectVar().getName());
                if (mappedSubject != null) {
                    subject = (Resource)mappedSubject.getValue();
                } else {
                    subject = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getSubjectVar().getName(), subject);
                }
            }
        }
        predicate = pattern.getPredicateVar().hasValue() ? (URI)pattern.getPredicateVar().getValue() : (URI)sourceBinding.getValue(pattern.getPredicateVar().getName());
        if (pattern.getObjectVar().hasValue()) {
            object = pattern.getObjectVar().getValue();
        } else {
            object = sourceBinding.getValue(pattern.getObjectVar().getName());
            if (object == null && pattern.getObjectVar().isAnonymous()) {
                Binding mappedObject = bnodeMapping.getBinding(pattern.getObjectVar().getName());
                if (mappedObject != null) {
                    object = (Resource)mappedObject.getValue();
                } else {
                    object = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getObjectVar().getName(), object);
                }
            }
        }
        if (pattern.getContextVar() != null) {
            context = pattern.getContextVar().hasValue() ? (Resource)pattern.getContextVar().getValue() : (Resource)sourceBinding.getValue(pattern.getContextVar().getName());
        }
        Statement st = null;
        if (subject != null && predicate != null && object != null) {
            st = context != null ? this.vf.createStatement(subject, predicate, object, context) : this.vf.createStatement(subject, predicate, object);
        }
        return st;
    }

    private Value getValueForVar(Var var, BindingSet bindings) throws SailException {
        Value value = null;
        value = var.hasValue() ? var.getValue() : bindings.getValue(var.getName());
        return value;
    }
}

