/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.query.QueryStringUtil;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class SPARQLGraphQuery
extends AbstractHTTPQuery
implements GraphQuery {
    public SPARQLGraphQuery(HTTPClient httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    @Override
    public GraphQueryResult evaluate() throws QueryEvaluationException {
        HTTPClient client = this.getHttpClient();
        try {
            return client.sendGraphQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, false, this.maxQueryTime, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
    }

    @Override
    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        HTTPClient client = this.getHttpClient();
        try {
            client.sendGraphQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, this.includeInferred, this.maxQueryTime, handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

