/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import info.aduna.text.ASCIIUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.io.input.BOMInputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.turtle.TurtleUtil;

public class TurtleParser
extends RDFParserBase {
    private LineNumberReader lineReader;
    private PushbackReader reader;
    private Resource subject;
    private URI predicate;
    private Value object;

    public TurtleParser() {
    }

    public TurtleParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be 'null'");
        }
        try {
            this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), "UTF-8"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI must not be 'null'");
        }
        this.rdfHandler.startRDF();
        this.lineReader = new LineNumberReader(reader);
        this.lineReader.setLineNumber(1);
        this.reader = new PushbackReader(this.lineReader, 8);
        this.setBaseURI(baseURI);
        this.reportLocation();
        try {
            int c = this.skipWSC();
            while (c != -1) {
                this.parseStatement();
                c = this.skipWSC();
            }
        }
        finally {
            this.clear();
        }
        this.rdfHandler.endRDF();
    }

    protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
        StringBuilder sb = new StringBuilder(8);
        do {
            int c;
            if ((c = this.read()) == -1 || TurtleUtil.isWhitespace(c)) {
                this.unread(c);
                break;
            }
            sb.append((char)c);
        } while (sb.length() < 8);
        String directive = sb.toString();
        if (directive.startsWith("@") || directive.equalsIgnoreCase("prefix") || directive.equalsIgnoreCase("base")) {
            this.parseDirective(directive);
            this.skipWSC();
            if (directive.startsWith("@")) {
                this.verifyCharacterOrFail(this.read(), ".");
            }
        } else {
            this.unread(directive);
            this.parseTriples();
            this.skipWSC();
            this.verifyCharacterOrFail(this.read(), ".");
        }
    }

    protected void parseDirective(String directive) throws IOException, RDFParseException, RDFHandlerException {
        if (directive.equalsIgnoreCase("prefix") || directive.equalsIgnoreCase("@prefix")) {
            this.parsePrefixID();
        } else if (directive.equalsIgnoreCase("base") || directive.equalsIgnoreCase("@base")) {
            this.parseBase();
        } else if (directive.length() == 0) {
            this.reportFatalError("Directive name is missing, expected @prefix or @base");
        } else {
            this.reportFatalError("Unknown directive \"" + directive + "\"");
        }
    }

    protected void parsePrefixID() throws IOException, RDFParseException, RDFHandlerException {
        this.skipWSC();
        StringBuilder prefixID = new StringBuilder(8);
        while (true) {
            int c;
            if ((c = this.read()) == 58) {
                this.unread(c);
                break;
            }
            if (TurtleUtil.isWhitespace(c)) break;
            if (c == -1) {
                this.throwEOFException();
            }
            prefixID.append((char)c);
        }
        this.skipWSC();
        this.verifyCharacterOrFail(this.read(), ":");
        this.skipWSC();
        URI namespace = this.parseURI();
        String prefixStr = prefixID.toString();
        String namespaceStr = namespace.toString();
        this.setNamespace(prefixStr, namespaceStr);
        this.rdfHandler.handleNamespace(prefixStr, namespaceStr);
    }

    protected void parseBase() throws IOException, RDFParseException, RDFHandlerException {
        this.skipWSC();
        URI baseURI = this.parseURI();
        this.setBaseURI(baseURI.toString());
    }

    protected void parseTriples() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peek();
        if (c == 91) {
            c = this.read();
            this.skipWSC();
            c = this.peek();
            if (c == 93) {
                c = this.read();
                this.subject = this.createBNode();
                this.skipWSC();
                this.parsePredicateObjectList();
            } else {
                this.unread(91);
                this.subject = this.parseImplicitBlank();
            }
            this.skipWSC();
            c = this.peek();
            if (c != 46) {
                this.parsePredicateObjectList();
            }
        } else {
            this.parseSubject();
            this.skipWSC();
            this.parsePredicateObjectList();
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    protected void parsePredicateObjectList() throws IOException, RDFParseException, RDFHandlerException {
        this.predicate = this.parsePredicate();
        this.skipWSC();
        this.parseObjectList();
        while (this.skipWSC() == 59) {
            this.read();
            int c = this.skipWSC();
            if (c == 46 || c == 93) break;
            if (c == 59) continue;
            this.predicate = this.parsePredicate();
            this.skipWSC();
            this.parseObjectList();
        }
    }

    protected void parseObjectList() throws IOException, RDFParseException, RDFHandlerException {
        this.parseObject();
        while (this.skipWSC() == 44) {
            this.read();
            this.skipWSC();
            this.parseObject();
        }
    }

    protected void parseSubject() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peek();
        if (c == 40) {
            this.subject = this.parseCollection();
        } else if (c == 91) {
            this.subject = this.parseImplicitBlank();
        } else {
            Value value = this.parseValue();
            if (value instanceof Resource) {
                this.subject = (Resource)value;
            } else {
                this.reportFatalError("Illegal subject value: " + value);
            }
        }
    }

    protected URI parsePredicate() throws IOException, RDFParseException {
        int c1 = this.read();
        if (c1 == 97) {
            int c2 = this.read();
            if (TurtleUtil.isWhitespace(c2)) {
                return RDF.TYPE;
            }
            this.unread(c2);
        }
        this.unread(c1);
        Value predicate = this.parseValue();
        if (predicate instanceof URI) {
            return (URI)predicate;
        }
        this.reportFatalError("Illegal predicate value: " + predicate);
        return null;
    }

    protected void parseObject() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peek();
        this.object = c == 40 ? this.parseCollection() : (c == 91 ? this.parseImplicitBlank() : this.parseValue());
        this.reportStatement(this.subject, this.predicate, this.object);
    }

    protected Resource parseCollection() throws IOException, RDFParseException, RDFHandlerException {
        this.verifyCharacterOrFail(this.read(), "(");
        int c = this.skipWSC();
        if (c == 41) {
            this.read();
            return RDF.NIL;
        }
        BNode listRoot = this.createBNode();
        Resource oldSubject = this.subject;
        URI oldPredicate = this.predicate;
        this.subject = listRoot;
        this.predicate = RDF.FIRST;
        this.parseObject();
        BNode bNode = listRoot;
        while (this.skipWSC() != 41) {
            BNode newNode = this.createBNode();
            this.reportStatement(bNode, RDF.REST, newNode);
            bNode = newNode;
            this.subject = bNode;
            this.parseObject();
        }
        this.read();
        this.reportStatement(bNode, RDF.REST, RDF.NIL);
        this.subject = oldSubject;
        this.predicate = oldPredicate;
        return listRoot;
    }

    protected Resource parseImplicitBlank() throws IOException, RDFParseException, RDFHandlerException {
        this.verifyCharacterOrFail(this.read(), "[");
        BNode bNode = this.createBNode();
        int c = this.read();
        if (c != 93) {
            this.unread(c);
            Resource oldSubject = this.subject;
            URI oldPredicate = this.predicate;
            this.subject = bNode;
            this.skipWSC();
            this.parsePredicateObjectList();
            this.skipWSC();
            this.verifyCharacterOrFail(this.read(), "]");
            this.subject = oldSubject;
            this.predicate = oldPredicate;
        }
        return bNode;
    }

    protected Value parseValue() throws IOException, RDFParseException {
        int c = this.peek();
        if (c == 60) {
            return this.parseURI();
        }
        if (c == 58 || TurtleUtil.isPrefixStartChar(c)) {
            return this.parseQNameOrBoolean();
        }
        if (c == 95) {
            return this.parseNodeID();
        }
        if (c == 34 || c == 39) {
            return this.parseQuotedLiteral();
        }
        if (ASCIIUtil.isNumber(c) || c == 46 || c == 43 || c == 45) {
            return this.parseNumber();
        }
        if (c == -1) {
            this.throwEOFException();
            return null;
        }
        this.reportFatalError("Expected an RDF value here, found '" + (char)c + "'");
        return null;
    }

    protected Literal parseQuotedLiteral() throws IOException, RDFParseException {
        String label = this.parseQuotedString();
        int c = this.peek();
        if (c == 64) {
            boolean verifyLanguageTag;
            this.read();
            StringBuilder lang = new StringBuilder(8);
            c = this.read();
            if (c == -1) {
                this.throwEOFException();
            }
            if ((verifyLanguageTag = this.getParserConfig().get(BasicParserSettings.VERIFY_LANGUAGE_TAGS).booleanValue()) && !TurtleUtil.isLanguageStartChar(c)) {
                this.reportError("Expected a letter, found '" + (char)c + "'", BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            }
            lang.append((char)c);
            c = this.read();
            while (!TurtleUtil.isWhitespace(c)) {
                if (verifyLanguageTag && !TurtleUtil.isLanguageChar(c)) {
                    this.reportError("Illegal language tag char: '" + (char)c + "'", BasicParserSettings.VERIFY_LANGUAGE_TAGS);
                }
                lang.append((char)c);
                c = this.read();
            }
            this.unread(c);
            return this.createLiteral(label, lang.toString(), null);
        }
        if (c == 94) {
            this.read();
            this.verifyCharacterOrFail(this.read(), "^");
            Value datatype = this.parseValue();
            if (datatype instanceof URI) {
                return this.createLiteral(label, null, (URI)datatype);
            }
            this.reportFatalError("Illegal datatype value: " + datatype);
            return null;
        }
        return this.createLiteral(label, null, null);
    }

    protected String parseQuotedString() throws IOException, RDFParseException {
        String result = null;
        int c1 = this.read();
        this.verifyCharacterOrFail(c1, "\"'");
        int c2 = this.read();
        int c3 = this.read();
        if (c1 == 34 && c2 == 34 && c3 == 34 || c1 == 39 && c2 == 39 && c3 == 39) {
            result = this.parseLongString(c2);
        } else {
            this.unread(c3);
            this.unread(c2);
            result = this.parseString(c1);
        }
        try {
            result = TurtleUtil.decodeString(result);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), BasicParserSettings.VERIFY_DATATYPE_VALUES);
        }
        return result;
    }

    protected String parseString(int closingCharacter) throws IOException, RDFParseException {
        int c;
        StringBuilder sb = new StringBuilder(32);
        while ((c = this.read()) != closingCharacter) {
            if (c == -1) {
                this.throwEOFException();
            }
            sb.append((char)c);
            if (c != 92) continue;
            c = this.read();
            if (c == -1) {
                this.throwEOFException();
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String parseLongString(int closingCharacter) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(1024);
        int doubleQuoteCount = 0;
        while (doubleQuoteCount < 3) {
            int c = this.read();
            if (c == -1) {
                this.throwEOFException();
            } else {
                doubleQuoteCount = c == closingCharacter ? ++doubleQuoteCount : 0;
            }
            sb.append((char)c);
            if (c != 92) continue;
            c = this.read();
            if (c == -1) {
                this.throwEOFException();
            }
            sb.append((char)c);
        }
        return sb.substring(0, sb.length() - 3);
    }

    protected Literal parseNumber() throws IOException, RDFParseException {
        StringBuilder value = new StringBuilder(8);
        URI datatype = XMLSchema.INTEGER;
        int c = this.read();
        if (c == 43 || c == 45) {
            value.append((char)c);
            c = this.read();
        }
        while (ASCIIUtil.isNumber(c)) {
            value.append((char)c);
            c = this.read();
        }
        if (c == 46 || c == 101 || c == 69) {
            if (c == 46) {
                if (!TurtleUtil.isWhitespace(this.peek())) {
                    value.append((char)c);
                    c = this.read();
                    while (ASCIIUtil.isNumber(c)) {
                        value.append((char)c);
                        c = this.read();
                    }
                    if (value.length() == 1) {
                        this.reportFatalError("Object for statement missing");
                    }
                    datatype = XMLSchema.DECIMAL;
                }
            } else if (value.length() == 0) {
                this.reportFatalError("Object for statement missing");
            }
            if (c == 101 || c == 69) {
                datatype = XMLSchema.DOUBLE;
                value.append((char)c);
                c = this.read();
                if (c == 43 || c == 45) {
                    value.append((char)c);
                    c = this.read();
                }
                if (!ASCIIUtil.isNumber(c)) {
                    this.reportError("Exponent value missing", BasicParserSettings.VERIFY_DATATYPE_VALUES);
                }
                value.append((char)c);
                c = this.read();
                while (ASCIIUtil.isNumber(c)) {
                    value.append((char)c);
                    c = this.read();
                }
            }
        }
        this.unread(c);
        return this.createLiteral(value.toString(), null, datatype);
    }

    protected URI parseURI() throws IOException, RDFParseException {
        StringBuilder uriBuf = new StringBuilder(100);
        int c = this.read();
        this.verifyCharacterOrFail(c, "<");
        while ((c = this.read()) != 62) {
            if (c == -1) {
                this.throwEOFException();
            }
            uriBuf.append((char)c);
            if (c != 92) continue;
            c = this.read();
            if (c == -1) {
                this.throwEOFException();
            }
            uriBuf.append((char)c);
        }
        String uri = uriBuf.toString();
        try {
            uri = TurtleUtil.decodeString(uri);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), BasicParserSettings.VERIFY_DATATYPE_VALUES);
        }
        return super.resolveURI(uri);
    }

    protected Value parseQNameOrBoolean() throws IOException, RDFParseException {
        int c = this.read();
        if (c == -1) {
            this.throwEOFException();
        }
        if (c != 58 && !TurtleUtil.isPrefixStartChar(c)) {
            this.reportError("Expected a ':' or a letter, found '" + (char)c + "'", BasicParserSettings.VERIFY_RELATIVE_URIS);
        }
        String namespace = null;
        if (c == 58) {
            namespace = this.getNamespace("");
        } else {
            String value;
            StringBuilder prefix = new StringBuilder(8);
            prefix.append((char)c);
            c = this.read();
            while (TurtleUtil.isPrefixChar(c)) {
                prefix.append((char)c);
                c = this.read();
            }
            if (c != 58 && ((value = prefix.toString()).equals("true") || value.equals("false"))) {
                return this.createLiteral(value, null, XMLSchema.BOOLEAN);
            }
            this.verifyCharacterOrFail(c, ":");
            namespace = this.getNamespace(prefix.toString());
        }
        StringBuilder localName = new StringBuilder(16);
        c = this.read();
        if (TurtleUtil.isNameStartChar(c)) {
            if (c == 92) {
                localName.append(this.readLocalEscapedChar());
            } else {
                localName.append((char)c);
            }
            c = this.read();
            while (TurtleUtil.isNameChar(c)) {
                if (c == 92) {
                    localName.append(this.readLocalEscapedChar());
                } else {
                    localName.append((char)c);
                }
                c = this.read();
            }
        }
        this.unread(c);
        return this.createURI(namespace + localName.toString());
    }

    private char readLocalEscapedChar() throws RDFParseException, IOException {
        int c = this.read();
        if (TurtleUtil.isLocalEscapedChar(c)) {
            return (char)c;
        }
        throw new RDFParseException("found '" + (char)c + "', expected one of: " + Arrays.toString(TurtleUtil.LOCAL_ESCAPED_CHARS));
    }

    protected BNode parseNodeID() throws IOException, RDFParseException {
        this.verifyCharacterOrFail(this.read(), "_");
        this.verifyCharacterOrFail(this.read(), ":");
        int c = this.read();
        if (c == -1) {
            this.throwEOFException();
        } else if (!TurtleUtil.isNameStartChar(c)) {
            this.reportError("Expected a letter, found '" + (char)c + "'", BasicParserSettings.PRESERVE_BNODE_IDS);
        }
        StringBuilder name = new StringBuilder(32);
        name.append((char)c);
        c = this.read();
        while (TurtleUtil.isNameChar(c)) {
            name.append((char)c);
            c = this.read();
        }
        this.unread(c);
        return this.createBNode(name.toString());
    }

    protected void reportStatement(Resource subj, URI pred, Value obj) throws RDFParseException, RDFHandlerException {
        Statement st = this.createStatement(subj, pred, obj);
        this.rdfHandler.handleStatement(st);
    }

    protected void verifyCharacterOrFail(int c, String expected) throws RDFParseException {
        if (c == -1) {
            this.throwEOFException();
        } else if (expected.indexOf((char)c) == -1) {
            StringBuilder msg = new StringBuilder(32);
            msg.append("Expected ");
            for (int i = 0; i < expected.length(); ++i) {
                if (i > 0) {
                    msg.append(" or ");
                }
                msg.append('\'');
                msg.append(expected.charAt(i));
                msg.append('\'');
            }
            msg.append(", found '");
            msg.append((char)c);
            msg.append("'");
            this.reportFatalError(msg.toString());
        }
    }

    protected int skipWSC() throws IOException, RDFHandlerException {
        int c = this.read();
        while (TurtleUtil.isWhitespace(c) || c == 35) {
            if (c == 35) {
                this.processComment();
            }
            c = this.read();
        }
        this.unread(c);
        return c;
    }

    protected void processComment() throws IOException, RDFHandlerException {
        StringBuilder comment = new StringBuilder(64);
        int c = this.read();
        while (c != -1 && c != 13 && c != 10) {
            comment.append((char)c);
            c = this.read();
        }
        if (c == 13 && (c = this.read()) != 10) {
            this.unread(c);
        }
        this.rdfHandler.handleComment(comment.toString());
        this.reportLocation();
    }

    protected int read() throws IOException {
        return this.reader.read();
    }

    protected void unread(int c) throws IOException {
        if (c != -1) {
            this.reader.unread(c);
        }
    }

    protected void unread(String directive) throws IOException {
        for (int i = directive.length() - 1; i >= 0; --i) {
            this.reader.unread(directive.charAt(i));
        }
    }

    protected int peek() throws IOException {
        int result = this.read();
        this.unread(result);
        return result;
    }

    protected void reportLocation() {
        this.reportLocation(this.lineReader.getLineNumber(), -1);
    }

    @Override
    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.lineReader.getLineNumber(), -1);
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, this.lineReader.getLineNumber(), -1, setting);
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.lineReader.getLineNumber(), -1);
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.lineReader.getLineNumber(), -1);
    }

    protected void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }
}

