/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.config;

import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailConfigSchema;
import org.openrdf.sail.config.SailImplConfig;

public class SailImplConfigBase
implements SailImplConfig {
    private String type;

    public SailImplConfigBase() {
    }

    public SailImplConfigBase(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws SailConfigException {
        if (this.type == null) {
            throw new SailConfigException("No type specified for sail implementation");
        }
    }

    @Override
    public Resource export(Graph graph) {
        BNode implNode = graph.getValueFactory().createBNode();
        if (this.type != null) {
            graph.add(implNode, SailConfigSchema.SAILTYPE, graph.getValueFactory().createLiteral(this.type), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        try {
            Literal typeLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, SailConfigSchema.SAILTYPE);
            if (typeLit != null) {
                this.setType(typeLit.getLabel());
            }
        }
        catch (GraphUtilException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

