/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.evaluation;

import info.aduna.iteration.LookAheadIteration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.openrdf.query.QueryEvaluationException;

public class QueueCursor<E>
extends LookAheadIteration<E, QueryEvaluationException> {
    private volatile boolean done;
    private BlockingQueue<E> queue;
    private final E afterLast = this.createAfterLast();
    private volatile Queue<Throwable> exceptions = new LinkedList<Throwable>();

    public QueueCursor(int capacity) {
        this(capacity, false);
    }

    public QueueCursor(int capacity, boolean fair) {
        this.queue = new ArrayBlockingQueue(capacity, fair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toss(Exception exception) {
        Queue<Throwable> queue = this.exceptions;
        synchronized (queue) {
            this.exceptions.add(exception);
        }
    }

    public void put(E item) throws InterruptedException {
        this.queue.put(item);
    }

    public void done() {
        this.done = true;
        try {
            this.queue.add(this.afterLast);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public E getNextElement() throws QueryEvaluationException {
        try {
            Object take;
            this.checkException();
            if (this.done) {
                take = this.queue.poll();
            } else {
                take = this.queue.take();
                if (this.done) {
                    this.done();
                }
            }
            if (this.isAfterLast(take)) {
                this.checkException();
                this.done();
                take = null;
            }
            return take;
        }
        catch (InterruptedException e) {
            this.checkException();
            throw new QueryEvaluationException(e);
        }
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        this.checkException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkException() throws QueryEvaluationException {
        Queue<Throwable> queue = this.exceptions;
        synchronized (queue) {
            if (!this.exceptions.isEmpty()) {
                try {
                    throw this.exceptions.remove();
                }
                catch (QueryEvaluationException e) {
                    this.modifyStackTraceAndRethrow(e, 1);
                }
                catch (RuntimeException e) {
                    this.modifyStackTraceAndRethrow(e, 0);
                }
                catch (Throwable e) {
                    throw new QueryEvaluationException(e);
                }
            }
        }
    }

    private <X extends Exception> void modifyStackTraceAndRethrow(X exception, int firstIndex) throws X {
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        stack.addAll(Arrays.asList(exception.getStackTrace()));
        StackTraceElement[] thisStack = new Throwable().getStackTrace();
        stack.addAll(Arrays.asList(thisStack).subList(firstIndex, thisStack.length));
        exception.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
        throw exception;
    }

    private boolean isAfterLast(E take) {
        return take == null || take == this.afterLast;
    }

    private E createAfterLast() {
        return (E)new Object();
    }
}

