/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.ReducedIteration;
import info.aduna.iteration.UnionIteration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DirectoryLockManager;
import org.openrdf.sail.helpers.NotifyingSailBase;
import org.openrdf.sail.nativerdf.NamespaceStore;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.NativeStoreConnection;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

public class NativeStore
extends NotifyingSailBase {
    private volatile String tripleIndexes;
    private volatile boolean forceSync = false;
    private volatile int valueCacheSize = 512;
    private volatile int valueIDCacheSize = 128;
    private volatile int namespaceCacheSize = 64;
    private volatile int namespaceIDCacheSize = 32;
    private volatile TripleStore tripleStore;
    private volatile ValueStore valueStore;
    private volatile NamespaceStore namespaceStore;
    private final ExclusiveLockManager txnLockManager = new ExclusiveLockManager(NativeStore.debugEnabled());
    private volatile Lock dirLock;

    public NativeStore() {
    }

    public NativeStore(File dataDir) {
        this();
        this.setDataDir(dataDir);
    }

    public NativeStore(File dataDir, String tripleIndexes) {
        this(dataDir);
        this.setTripleIndexes(tripleIndexes);
    }

    public void setTripleIndexes(String tripleIndexes) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.tripleIndexes = tripleIndexes;
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    @Override
    protected void initializeInternal() throws SailException {
        this.logger.debug("Initializing NativeStore...");
        File dataDir = this.getDataDir();
        if (dataDir == null) {
            throw new SailException("Data dir has not been set");
        }
        if (!dataDir.exists()) {
            boolean success = dataDir.mkdirs();
            if (!success) {
                throw new SailException("Unable to create data directory: " + dataDir);
            }
        } else {
            if (!dataDir.isDirectory()) {
                throw new SailException("The specified path does not denote a directory: " + dataDir);
            }
            if (!dataDir.canRead()) {
                throw new SailException("Not allowed to read from the specified directory: " + dataDir);
            }
        }
        this.dirLock = new DirectoryLockManager(dataDir).lockOrFail();
        this.logger.debug("Data dir is " + dataDir);
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(dataDir, this.forceSync, this.valueCacheSize, this.valueIDCacheSize, this.namespaceCacheSize, this.namespaceIDCacheSize);
            this.tripleStore = new TripleStore(dataDir, this.tripleIndexes, this.forceSync);
        }
        catch (IOException e) {
            if (this.valueStore != null) {
                try {
                    this.valueStore.close();
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to close value store after native store initialization failure", e);
                }
                this.valueStore = null;
            }
            if (this.namespaceStore != null) {
                this.namespaceStore.close();
                this.namespaceStore = null;
            }
            this.dirLock.release();
            throw new SailException(e);
        }
        this.logger.debug("NativeStore initialized");
    }

    @Override
    protected void shutDownInternal() throws SailException {
        this.logger.debug("Shutting down NativeStore...");
        try {
            this.tripleStore.close();
            this.valueStore.close();
            this.namespaceStore.close();
            this.logger.debug("NativeStore shut down");
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        finally {
            this.dirLock.release();
        }
    }

    @Override
    public boolean isWritable() {
        return this.getDataDir().canWrite();
    }

    @Override
    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        try {
            return new NativeStoreConnection(this);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    protected TripleStore getTripleStore() {
        return this.tripleStore;
    }

    protected ValueStore getValueStore() {
        return this.valueStore;
    }

    protected NamespaceStore getNamespaceStore() {
        return this.namespaceStore;
    }

    protected Lock getTransactionLock() throws SailException {
        try {
            return this.txnLockManager.getExclusiveLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected List<Integer> getContextIDs(Resource ... contexts) throws IOException {
        assert (contexts.length > 0) : "contexts must not be empty";
        LinkedHashSet contextSet = new LinkedHashSet();
        Collections.addAll(contextSet, contexts);
        ArrayList<Integer> contextIDs = new ArrayList<Integer>(contextSet.size());
        for (Resource context : contextSet) {
            if (context == null) {
                contextIDs.add(0);
                continue;
            }
            int contextID = this.valueStore.getID(context);
            if (contextID == -1) continue;
            contextIDs.add(contextID);
        }
        return contextIDs;
    }

    protected CloseableIteration<Resource, IOException> getContextIDs(boolean readTransaction) throws IOException {
        RecordIterator btreeIter = this.tripleStore.getAllTriplesSortedByContext(readTransaction);
        CloseableIteration<Statement, IOException> stIter = btreeIter == null ? this.createStatementIterator(null, null, null, true, readTransaction, new Resource[0]) : new NativeStatementIterator(btreeIter, this.valueStore);
        stIter = new FilterIteration<Statement, IOException>((Iteration)stIter){

            @Override
            protected boolean accept(Statement st) {
                return st.getContext() != null;
            }
        };
        CloseableIterationBase ctxIter = new ConvertingIteration<Statement, Resource, IOException>((Iteration)stIter){

            @Override
            protected Resource convert(Statement st) {
                return st.getContext();
            }
        };
        ctxIter = btreeIter == null ? new DistinctIteration<Resource, IOException>(ctxIter) : new ReducedIteration<Resource, IOException>(ctxIter);
        return ctxIter;
    }

    protected CloseableIteration<? extends Statement, IOException> createStatementIterator(Resource subj, URI pred, Value obj, boolean includeInferred, boolean readTransaction, Resource ... contexts) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return new EmptyIteration();
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return new EmptyIteration();
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return new EmptyIteration();
        }
        ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1);
        } else {
            for (Resource context : contexts) {
                if (context == null) {
                    contextIDList.add(0);
                    continue;
                }
                int contextID = this.valueStore.getID(context);
                if (contextID == -1) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<NativeStatementIterator> perContextIterList = new ArrayList<NativeStatementIterator>(contextIDList.size());
        Iterator i$ = contextIDList.iterator();
        while (i$.hasNext()) {
            int contextID = (Integer)i$.next();
            RecordIterator btreeIter = includeInferred ? this.tripleStore.getTriples(subjID, predID, objID, contextID, readTransaction) : this.tripleStore.getTriples(subjID, predID, objID, contextID, true, readTransaction);
            perContextIterList.add(new NativeStatementIterator(btreeIter, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    protected double cardinality(Resource subj, URI pred, Value obj, Resource context) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return 0.0;
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return 0.0;
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return 0.0;
        }
        int contextID = -1;
        if (context != null && (contextID = this.valueStore.getID(context)) == -1) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }
}

