/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.LongURIColumn;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.URIColumn;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.SqlExprFactory;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

public class URIExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;
    private SqlExprFactory sql;

    public void setSqlExprFactory(SqlExprFactory sql) {
        this.sql = sql;
    }

    public SqlExpr createUriExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit(this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    @Override
    public void meet(Datatype node) throws UnsupportedRdbmsOperatorException {
        SqlCase sqlCase = new SqlCase();
        sqlCase.when(SqlExprSupport.isNotNull(this.type(node.getArg())), this.type(node.getArg()));
        sqlCase.when(SqlExprSupport.isNotNull(this.lang(node.getArg())), SqlExprSupport.str(RDF.LANGSTRING.stringValue()));
        sqlCase.when(SqlExprSupport.and(SqlExprSupport.isNull(this.lang(node.getArg())), SqlExprSupport.isNotNull(this.label(node.getArg()))), SqlExprSupport.str(XMLSchema.STRING.stringValue()));
        this.result = sqlCase;
    }

    @Override
    public void meet(Lang node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(MathExpr node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(Str node) {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    @Override
    public void meet(Var var) {
        this.result = var.getValue() == null ? SqlExprSupport.coalesce(new URIColumn(var), new LongURIColumn(var)) : this.valueOf(var.getValue());
    }

    @Override
    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    private SqlExpr label(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createLabelExpr(arg);
    }

    private SqlExpr lang(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createLanguageExpr(arg);
    }

    private SqlExpr type(ValueExpr arg) throws UnsupportedRdbmsOperatorException {
        return this.sql.createDatatypeExpr(arg);
    }

    private SqlExpr valueOf(Value value) {
        if (value instanceof URI) {
            return SqlExprSupport.str(((URI)value).stringValue());
        }
        return SqlExprSupport.sqlNull();
    }
}

