/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.annot;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.model.graph.G;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.Util;

public class GraphLoader_TSVannot
implements GraphLoader {
    public static final String PARAM_HEADER = "header";
    public static final String PARAM_PREFIX_SUBJECT = "prefixSubject";
    public static final String PARAM_PREFIX_OBJECT = "prefixObject";
    public static final String PARAM_PREDICATE = "predicate";
    boolean skipHeader = false;
    URIFactoryMemory uriRepo = URIFactoryMemory.getSingleton();
    Character pattern = Character.valueOf('\t');
    G g;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    URI predicate = RDF.TYPE;
    String prefixSubject = null;
    String prefixObject = null;
    Pattern colon = Pattern.compile(":");

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.logger.info("-------------------------------------");
        this.logger.info("Loading Annotations using TSV loader.");
        this.logger.info("-------------------------------------");
        this.g = g;
        this.loadConf(conf);
        this.loadTSV(conf.getLoc());
        this.logger.info("TSV specification loaded.");
        this.logger.info("-------------------------------------");
    }

    private void loadConf(GDataConf conf) throws SLIB_Ex_Critic {
        String header = (String)conf.getParameter(PARAM_HEADER);
        String prefixSubjectParam = (String)conf.getParameter(PARAM_PREFIX_SUBJECT);
        String prefixObjectParam = (String)conf.getParameter(PARAM_PREFIX_OBJECT);
        String predicateParam = (String)conf.getParameter(PARAM_PREDICATE);
        if (header == null || Util.stringToBoolean(header)) {
            this.skipHeader = true;
        }
        if (predicateParam != null) {
            try {
                this.predicate = this.uriRepo.getURI(predicateParam);
            }
            catch (IllegalArgumentException e) {
                throw new SLIB_Ex_Critic("Error in data loader, parameter predicate, cannot create an URI from " + predicateParam + "\n" + e.getMessage());
            }
        }
        if (prefixSubjectParam != null) {
            this.prefixSubject = prefixSubjectParam;
        }
        if (prefixObjectParam != null) {
            this.prefixObject = prefixObjectParam;
        }
        this.logger.info("file            " + conf.getLoc());
        this.logger.info("Skipping header " + this.skipHeader);
        this.logger.info("predicate       '" + this.predicate + "'");
        if (this.prefixSubject != null) {
            this.logger.info("prefix subject  '" + this.prefixSubject + "'");
        }
        if (this.prefixObject != null) {
            this.logger.info("prefix object   '" + this.prefixObject + "'");
        }
    }

    public void loadTSV(String fileLoc) throws SLIB_Ex_Critic {
        try {
            String[] row;
            CSVReader csvReader = new CSVReader(new FileReader(fileLoc), '\t');
            int skipped = 0;
            int statementsLoaded = 0;
            int processed = 0;
            while ((row = csvReader.readNext()) != null) {
                if (this.skipHeader) {
                    this.skipHeader = false;
                    continue;
                }
                if (row.length == 2) {
                    String subjectLocalName = row[0];
                    String[] data = row[1].split(";");
                    URI s = this.prefixSubject == null ? this.uriRepo.getURI(subjectLocalName) : this.uriRepo.getURI(this.prefixSubject + subjectLocalName);
                    for (String os : data) {
                        URI o = this.prefixObject == null ? this.uriRepo.getURI(this.buildURIString(os)) : this.uriRepo.getURI(this.prefixObject + os);
                        Edge edge = new Edge(s, this.predicate, o);
                        this.g.addE(edge);
                        ++statementsLoaded;
                    }
                    ++processed;
                    continue;
                }
                ++skipped;
            }
            csvReader.close();
            this.logger.info("Number of lines skipped   " + skipped);
            this.logger.info("Number of lines processed " + processed);
            this.logger.info("Number of statements loaded " + statementsLoaded);
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic("Error processing file " + fileLoc + "\n" + e.getMessage());
        }
    }

    private String buildURIString(String value) throws SLIB_Ex_Critic {
        String[] info = this.getDataColonSplit(value);
        if (info != null && info.length == 2) {
            String ns = this.uriRepo.getNamespace(info[0]);
            if (ns == null) {
                throw new SLIB_Ex_Critic("No namespace associated to prefix " + info[0] + ". Cannot load " + value + ", please load required namespace prefix");
            }
            return ns + info[1];
        }
        return value;
    }

    private String[] getDataColonSplit(String value) {
        String[] data = this.colon.split(value);
        data[0] = data[0].trim();
        if (data.length > 1) {
            data[1] = data[1].trim();
        }
        return data;
    }
}

