/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.slibformat;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class GraphLoader_SLIB
implements GraphLoader {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    URIFactory factory;
    String filepath;
    G g;

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.process(conf, g);
    }

    public void process(GDataConf conf, G graph) throws SLIB_Exception {
        this.g = graph;
        this.factory = URIFactoryMemory.getSingleton();
        this.filepath = conf.getLoc();
        this.logger.info("-------------------------------------");
        this.logger.info(" SLIB loader");
        this.logger.info("-------------------------------------");
        this.logger.info("Loading graph from SLIB formatted file" + this.filepath);
        try {
            String line;
            FileInputStream fstream = new FileInputStream(this.filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] dataTMP = line.split("\t");
                if (dataTMP.length == 1) {
                    URI vURI = this.factory.getURI(dataTMP[0]);
                    this.g.addV(vURI);
                    continue;
                }
                if (dataTMP.length == 3) {
                    URI sURI = this.factory.getURI(dataTMP[0]);
                    URI pURI = this.factory.getURI(dataTMP[1]);
                    URI oURI = this.factory.getURI(dataTMP[2]);
                    this.g.addV(sURI);
                    this.g.addV(oURI);
                    this.g.addE(sURI, pURI, oURI);
                    continue;
                }
                throw new SLIB_Ex_Critic("Cannot process the following line " + line);
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.logger.info("-------------------------------------");
    }

    public void flush(G g, String outfile) throws SLIB_Ex_Critic {
        try {
            FileWriter fstream = new FileWriter(outfile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("# vertices " + g.getV().size() + "\n");
            out.write("# edges " + g.getE().size() + "\n");
            for (URI v : g.getV()) {
                out.write(v.stringValue() + "\n");
            }
            for (E e : g.getE()) {
                out.write(e.getSource().stringValue() + "\t" + e.getURI().stringValue() + "\t" + e.getTarget().stringValue() + "\n");
            }
            out.close();
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }
}

