/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.wordnet;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.util.GFormat;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.graph.memory.GraphMemory;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class GraphLoader_Wordnet_Full
implements GraphLoader {
    private G graph;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    URIFactoryMemory dataRepo = URIFactoryMemory.getSingleton();
    public static final Map<String, URI> pointerSymbolsToURIs = new HashMap<String, URI>();

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.logger.info("-------------------------------------");
        this.logger.info(" WordNet Loader");
        this.logger.info("-------------------------------------");
        this.logger.info("Loading from Wordnet data");
        if (conf.getFormat() != GFormat.WORDNET_DATA) {
            throw new SLIB_Ex_Critic("Cannot use " + this.getClass() + " to load file format " + (Object)((Object)conf.getFormat()) + ", required format is " + (Object)((Object)GFormat.WORDNET_DATA));
        }
        this.graph = g;
        boolean inHeader = true;
        String filepath = conf.getLoc();
        this.logger.info("From " + filepath);
        this.logger.info("-----------------------------------------------------------");
        String uriPrefix = g.getURI().getNamespace();
        if (conf.getParameter("prefix") != null) {
            uriPrefix = (String)conf.getParameter("prefix");
        }
        try {
            String line;
            if (filepath == null) {
                throw new SLIB_Ex_Critic("Error please precise a  file to load.");
            }
            FileInputStream fstream = new FileInputStream(filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                Pointer[] pointers;
                if (inHeader) {
                    if (line.startsWith("  ")) continue;
                    inHeader = false;
                }
                line = line.trim();
                String[] data = line.split("\\s+");
                String synset_offset = data[0];
                String lex_filenum = data[1];
                String ss_type = data[2];
                URI synset = this.dataRepo.getURI(uriPrefix + synset_offset);
                this.graph.addV(synset);
                int w_cnt = Integer.parseInt(data[3], 16);
                Word[] words = this.extractWords(data, 4, w_cnt);
                int c = 3 + w_cnt * 2 + 1;
                int p_cnt = Integer.parseInt(data[c]);
                for (Pointer p : pointers = this.extractPointers(data, c + 1, p_cnt)) {
                    if (!pointerSymbolsToURIs.containsKey(p.pointerSymbol)) {
                        throw new SLIB_Ex_Critic("No URI associated to pointer " + p.pointerSymbol);
                    }
                    URI s = this.dataRepo.getURI(uriPrefix + synset_offset);
                    URI o = this.dataRepo.getURI(uriPrefix + p.synsetOffset);
                    URI pr = pointerSymbolsToURIs.get(p.pointerSymbol);
                    this.graph.addV(s);
                    this.graph.addV(o);
                    Edge e = new Edge(s, pr, o);
                    g.addE(e);
                }
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic("Error loading the file: " + e.getMessage());
        }
        this.logger.info(this.graph.toString());
        this.logger.info("Wordnet Loading ok.");
        this.logger.info("-------------------------------------");
    }

    private Word[] extractWords(String[] data, int start_id, int w_cnt) {
        int c = 0;
        Word[] words = new Word[w_cnt];
        int i = start_id;
        while (c < w_cnt) {
            words[c] = new Word(data[i], Integer.parseInt(data[i + 1], 16));
            ++c;
            i += 2;
        }
        return words;
    }

    private Pointer[] extractPointers(String[] data, int start_id, int p_cnt) {
        int c = 0;
        Pointer[] pointers = new Pointer[p_cnt];
        int i = start_id;
        while (c < p_cnt) {
            Pointer p;
            String pointerSymbol = data[i];
            String synsetOffset = data[i + 1];
            String pos = data[i + 2];
            String src_target = data[i + 3];
            pointers[c] = p = new Pointer(pointerSymbol, synsetOffset, pos, src_target);
            ++c;
            i += 4;
        }
        return pointers;
    }

    public static void main(String[] args) throws SLIB_Exception {
        String dataloc = "/data/WordNet/WordNet-3.1/dict/";
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        URI guri = factory.getURI("http://graph/wordnet/");
        GraphMemory wordnet = new GraphMemory(guri);
        GraphLoader_Wordnet_Full loader = new GraphLoader_Wordnet_Full();
        GDataConf dataNoun = new GDataConf(GFormat.WORDNET_DATA, dataloc + "data.noun");
        GDataConf dataVerb = new GDataConf(GFormat.WORDNET_DATA, dataloc + "data.verb");
        GDataConf dataAdj = new GDataConf(GFormat.WORDNET_DATA, dataloc + "data.adj");
        GDataConf dataAdv = new GDataConf(GFormat.WORDNET_DATA, dataloc + "data.adv");
        loader.populate(dataNoun, wordnet);
        loader.populate(dataVerb, wordnet);
        loader.populate(dataAdj, wordnet);
        loader.populate(dataAdv, wordnet);
    }

    static {
        URIFactoryMemory f = URIFactoryMemory.getSingleton();
        pointerSymbolsToURIs.put("!", f.getURI("http://SML/wordNet/Antonym"));
        pointerSymbolsToURIs.put("@", f.getURI("http://SML/wordNet/Hypernym"));
        pointerSymbolsToURIs.put("@i", f.getURI("http://SML/wordNet/InstanceHypernym"));
        pointerSymbolsToURIs.put("~", f.getURI("http://SML/wordNet/Hyponym"));
        pointerSymbolsToURIs.put("~i", f.getURI("http://SML/wordNet/InstanceHyponym"));
        pointerSymbolsToURIs.put("#m", f.getURI("http://SML/wordNet/MemberHolonym"));
        pointerSymbolsToURIs.put("#s", f.getURI("http://SML/wordNet/SubstanceHolonym"));
        pointerSymbolsToURIs.put("#p", f.getURI("http://SML/wordNet/PartHolonym"));
        pointerSymbolsToURIs.put("%m", f.getURI("http://SML/wordNet/MemberMeronym"));
        pointerSymbolsToURIs.put("%s", f.getURI("http://SML/wordNet/SubstanceMeronym"));
        pointerSymbolsToURIs.put("%p", f.getURI("http://SML/wordNet/PartMeronym"));
        pointerSymbolsToURIs.put("=", f.getURI("http://SML/wordNet/Attribut"));
        pointerSymbolsToURIs.put("+", f.getURI("http://SML/wordNet/DerivationallyRelatedForm"));
        pointerSymbolsToURIs.put(";c", f.getURI("http://SML/wordNet/DomainOfTopic"));
        pointerSymbolsToURIs.put("-c", f.getURI("http://SML/wordNet/MemberOfTopic"));
        pointerSymbolsToURIs.put(";r", f.getURI("http://SML/wordNet/DomainOfRegion"));
        pointerSymbolsToURIs.put("-r", f.getURI("http://SML/wordNet/MemberOfRegion"));
        pointerSymbolsToURIs.put(";u", f.getURI("http://SML/wordNet/DomainOfUsage"));
        pointerSymbolsToURIs.put("-u", f.getURI("http://SML/wordNet/MemberOfUsage"));
        pointerSymbolsToURIs.put("&", f.getURI("http://SML/wordNet/SimilarTo"));
        pointerSymbolsToURIs.put("*", f.getURI("http://SML/wordNet/Entailment"));
        pointerSymbolsToURIs.put(">", f.getURI("http://SML/wordNet/Cause"));
        pointerSymbolsToURIs.put("^", f.getURI("http://SML/wordNet/AlsoSee"));
        pointerSymbolsToURIs.put("$", f.getURI("http://SML/wordNet/VerbGroup"));
        pointerSymbolsToURIs.put("<", f.getURI("http://SML/wordNet/ParticipleOfVerb"));
        pointerSymbolsToURIs.put("\\", f.getURI("http://SML/wordNet/DerivedPertains"));
    }

    private class PointerToEdge {
        URI rel;
        boolean fromSourceToTarget;

        public PointerToEdge(URI rel, boolean fromSourceToTarget) {
            this.rel = rel;
            this.fromSourceToTarget = fromSourceToTarget;
        }

        public E createEdge(URI srcPointer, URI targetPointer) {
            Edge e = this.fromSourceToTarget ? new Edge(srcPointer, this.rel, targetPointer) : new Edge(targetPointer, this.rel, srcPointer);
            return e;
        }
    }

    private class Pointer {
        String pointerSymbol;
        String synsetOffset;
        String pos;
        String src_target;

        private Pointer(String pointerSymbol, String synsetOffset, String pos, String src_target) {
            this.pointerSymbol = pointerSymbol;
            this.synsetOffset = synsetOffset;
            this.src_target = src_target;
            this.pos = pos;
        }

        public String toString() {
            return "symbol: " + this.pointerSymbol + "  synsetOffset: " + this.synsetOffset + "  src_target: " + this.src_target + "  pos: " + this.pos + "  ";
        }
    }

    private class Word {
        String word;
        int lex_id;

        Word(String word, int lex_id) {
            this.word = word;
            this.lex_id = lex_id;
        }

        public String toString() {
            return this.word + "(" + this.lex_id + ")";
        }
    }
}

