/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.utils;

import java.util.HashMap;
import org.openrdf.model.URI;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;

public class WalkConstraintUtils {
    public static WalkConstraint getInverse(WalkConstraint wc, boolean includeBOTHpredicate) {
        HashMap<URI, Direction> oppositeAcceptedWalks = new HashMap<URI, Direction>();
        for (URI e : wc.getAcceptedWalks_DIR_IN()) {
            oppositeAcceptedWalks.put(e, Direction.OUT);
        }
        for (URI e : wc.getAcceptedWalks_DIR_OUT()) {
            oppositeAcceptedWalks.put(e, Direction.IN);
        }
        if (includeBOTHpredicate) {
            for (URI e : wc.getAcceptedWalks_DIR_BOTH()) {
                oppositeAcceptedWalks.put(e, Direction.BOTH);
            }
        }
        return new WalkConstraintGeneric(oppositeAcceptedWalks);
    }

    public static WalkConstraint copy(WalkConstraint walkConstraint) {
        WalkConstraintGeneric newwc = new WalkConstraintGeneric();
        newwc.addAcceptedTraversal(walkConstraint.getAcceptedWalks_DIR_IN(), Direction.IN);
        newwc.addAcceptedTraversal(walkConstraint.getAcceptedWalks_DIR_OUT(), Direction.OUT);
        newwc.addAcceptedTraversal(walkConstraint.getAcceptedWalks_DIR_BOTH(), Direction.BOTH);
        return newwc;
    }
}

