/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.edge_based;

import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.model.graph.weight.GWS;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.Sim_DAG_edge_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Dist_pairwise_DAG_edge_Rada_LCA_1989
extends Sim_DAG_edge_abstract {
    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        GWS weightingScheme = c.getWeightingScheme(conf.getParamAsString("WEIGHTING_SCHEME"));
        Map<URI, Double> minDists_cA = c.getAllShortestPath(a, weightingScheme);
        Map<URI, Double> minDists_cB = c.getAllShortestPath(b, weightingScheme);
        Set<URI> ancestors_A = c.getAncestorsInc(a);
        Set<URI> ancestors_B = c.getAncestorsInc(b);
        Map<URI, Integer> maxDepths = c.getMaxDepths();
        return this.compare(minDists_cA, minDists_cB, ancestors_A, ancestors_B, maxDepths);
    }

    private double compare(Map<URI, Double> minDists_cA, Map<URI, Double> minDists_cB, Set<URI> ancestors_A, Set<URI> ancestors_B, Map<URI, Integer> maxDepths) throws SLIB_Exception {
        double dist = 0.0;
        Set<URI> interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B);
        if (interSecAncestors.isEmpty()) {
            throw new SLIB_Ex_Critic("Error computing " + Dist_pairwise_DAG_edge_Rada_LCA_1989.class);
        }
        URI msa = SimDagEdgeUtils.searchMSA(interSecAncestors, maxDepths);
        dist = minDists_cA.get(msa) + minDists_cB.get(msa);
        return dist;
    }

    @Override
    public Boolean isSymmetric() {
        return false;
    }
}

