/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.smutils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.impl.BigFileReader;

public class ResultsMerger {
    Logger logger = LoggerFactory.getLogger(ResultsMerger.class);
    private String file_a;
    private String file_b;
    private String tmp_file_a_prefix = "SGL_FILE_A_TMP";
    private String tmp_file_b_prefix = "SGL_FILE_B_TMP";
    ArrayList<String> header_a;
    ArrayList<String> header_b;
    HashMap<String, Long> values_a_index;
    HashMap<String, Long> values_b_index;
    long file_number_a = 0L;
    long file_number_b = 0L;
    HashMap<String, String> values_a;
    HashMap<String, String> values_b;
    String tmp_dir = "/tmp/";
    public static int splitSize_default = 100;
    int splitSize = splitSize_default;

    public void process(String file_a, String file_b, String out) throws SLIB_Ex_Critic {
        this.logger.info("Merging results");
        this.logger.info("file A: " + file_a);
        this.logger.info("file B: " + file_b);
        this.values_a = new HashMap();
        this.values_b = new HashMap();
        this.file_a = file_a;
        this.file_b = file_b;
        this.loadData(true);
        this.loadData(false);
        this.checkEntrySetCoherency(this.values_a.keySet(), this.values_b.keySet());
        ArrayList<String> newHeader = this.mergeHeaders();
        HashMap<String, String> newValues = this.mergeValues();
        this.values_a = null;
        this.values_b = null;
        try {
            FileWriter fstream = new FileWriter(out);
            BufferedWriter outbuff = new BufferedWriter(fstream);
            outbuff.write(ResultsMerger.implodeArrayList(newHeader) + "\n");
            for (Map.Entry<String, String> e : newValues.entrySet()) {
                String outs = e.getKey() + "\t" + e.getValue() + "\n";
                outbuff.write(outs);
            }
            outbuff.close();
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic("Error: " + e.getMessage());
        }
        this.logger.info("output: " + out);
    }

    private void checkEntrySetCoherency(Set<String> entries_A, Set<String> entries_B) throws SLIB_Ex_Critic {
        this.logger.info("Check entry coherencies");
        long count = 0L;
        for (String q : entries_A) {
            if (entries_B.contains(q)) continue;
            this.logger.info("!!! " + q);
            ++count;
        }
        this.logger.info(count + " entries contained in file " + this.file_a + " not found in file " + this.file_b);
        long error = count;
        count = 0L;
        for (String q : entries_B) {
            if (entries_A.contains(q)) continue;
            this.logger.info("!!! " + q);
            ++count;
        }
        this.logger.info(count + " entries contained in file " + this.file_b + " not found in file " + this.file_a);
        if ((error += count) != 0L) {
            throw new SLIB_Ex_Critic("Incoherencies detected see rows prefixed by  !!! above ");
        }
    }

    public void processLarge(String file_a, String file_b, String output, String tmp_dir, Integer split_size) throws SLIB_Ex_Critic {
        this.values_a_index = new HashMap();
        this.values_b_index = new HashMap();
        this.file_a = file_a;
        this.file_b = file_b;
        this.tmp_dir = tmp_dir;
        if (split_size != null) {
            this.splitSize = split_size;
        }
        this.logger.info("Merging results");
        this.logger.info("file A \t: " + file_a);
        this.logger.info("file B \t: " + file_b);
        this.logger.info("tmp dir\t: " + tmp_dir);
        this.logger.info("output\t\t: " + output);
        this.logger.info("split size : " + this.splitSize);
        this.loadDataIndex(true);
        this.loadDataIndex(false);
        this.checkEntrySetCoherency(this.values_a_index.keySet(), this.values_b_index.keySet());
        ArrayList<String> newHeader = this.mergeHeaders();
        this.values_a = null;
        this.values_b = null;
        this.logger.info("Populating new file...");
        try {
            FileWriter fstream = new FileWriter(output);
            BufferedWriter outbuff = new BufferedWriter(fstream);
            outbuff.write(ResultsMerger.implodeArrayList(newHeader) + "\n");
            long line_nb = 0L;
            for (Map.Entry<String, Long> e : this.values_a_index.entrySet()) {
                if (++line_nb % 1000L == 0L) {
                    this.logger.info(line_nb + "/" + this.values_a_index.size());
                }
                String qentry = e.getKey();
                Long file_a_index = e.getValue();
                if (!this.values_b_index.containsKey(qentry)) {
                    throw new SLIB_Ex_Critic("Cannot locate entry corresponding to query " + qentry);
                }
                Long file_b_index = this.values_b_index.get(qentry);
                String outs = e.getKey() + "\t";
                String line_tmp = this.getLine(true, file_a_index);
                String[] data_tmp = line_tmp.split("\t");
                outbuff.write(outs + ResultsMerger.implodeArray(Arrays.copyOfRange(data_tmp, 2, data_tmp.length)) + "\t");
                line_tmp = this.getLine(false, file_b_index);
                data_tmp = line_tmp.split("\t");
                outbuff.write(ResultsMerger.implodeArray(Arrays.copyOfRange(data_tmp, 2, data_tmp.length)) + "\n");
            }
            outbuff.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLIB_Ex_Critic("Error: " + e.getMessage());
        }
        this.removeTmpFiles();
        this.logger.info("output: " + output);
    }

    private void removeTmpFiles() {
        File f;
        String fname;
        this.logger.info("Delete tmp files");
        String fileSeparator = System.getProperty("file.separator");
        String filePathName = this.tmp_file_a_prefix;
        int i = 0;
        while ((long)i < this.file_number_a) {
            fname = this.tmp_dir + fileSeparator + filePathName + "_" + i;
            f = new File(fname);
            f.delete();
            ++i;
        }
        filePathName = this.tmp_file_b_prefix;
        i = 0;
        while ((long)i < this.file_number_b) {
            fname = this.tmp_dir + fileSeparator + filePathName + "_" + i;
            f = new File(fname);
            f.delete();
            ++i;
        }
    }

    public String getLine(boolean isFile_A, Long file_index) throws SLIB_Ex_Critic {
        String out = null;
        long file_nb = file_index / (long)this.splitSize;
        long lineNumber = file_index % (long)this.splitSize;
        String filePathName = this.tmp_file_a_prefix;
        if (!isFile_A) {
            filePathName = this.tmp_file_b_prefix;
        }
        String fileSeparator = System.getProperty("file.separator");
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.tmp_dir + fileSeparator + filePathName + "_" + file_nb));
            long countLine = 0L;
            while ((line = br.readLine()) != null) {
                if (countLine == lineNumber) {
                    out = line.trim();
                    break;
                }
                ++countLine;
            }
            br.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        return out;
    }

    private static String implodeArray(String[] inputArray) {
        String output = "";
        StringBuilder sb = new StringBuilder();
        sb.append(inputArray[0]);
        for (int i = 1; i < inputArray.length; ++i) {
            sb.append("\t");
            sb.append(inputArray[i]);
        }
        output = sb.toString();
        return output;
    }

    private static String implodeArrayList(ArrayList<String> inputArray) {
        StringBuilder sb = new StringBuilder();
        sb.append(inputArray.get(0));
        for (int i = 1; i < inputArray.size(); ++i) {
            sb.append("\t");
            sb.append(inputArray.get(i));
        }
        return sb.toString();
    }

    private HashMap<String, String> mergeValues() throws SLIB_Ex_Critic {
        HashMap<String, String> newValues = new HashMap<String, String>();
        Set<Map.Entry<String, String>> eSet = this.values_a.entrySet();
        for (Map.Entry<String, String> e : eSet) {
            String q = e.getKey();
            String vb = this.values_b.get(q);
            if (vb != null) {
                String newVals = e.getValue();
                newVals = newVals + "\t" + vb;
                newValues.put(q, newVals);
                continue;
            }
            throw new SLIB_Ex_Critic("Cannot locate entry " + q + " in file " + this.file_b);
        }
        return newValues;
    }

    private void checkDuplicateHeaderFields() throws SLIB_Ex_Critic {
        for (int i = 2; i < this.header_a.size(); ++i) {
            for (int j = 2; j < this.header_b.size(); ++j) {
                if (!this.header_a.get(i).equals(this.header_b.get(j))) continue;
                throw new SLIB_Ex_Critic("Duplicate header fields");
            }
        }
    }

    private ArrayList<String> mergeHeaders() throws SLIB_Ex_Critic {
        this.logger.info("Merging headers");
        this.checkDuplicateHeaderFields();
        ArrayList<String> newHeader = new ArrayList<String>();
        for (int i = 0; i < this.header_a.size(); ++i) {
            newHeader.add(this.header_a.get(i));
        }
        for (int j = 2; j < this.header_b.size(); ++j) {
            newHeader.add(this.header_b.get(j));
        }
        return newHeader;
    }

    private void loadData(boolean isFile_A) throws SLIB_Ex_Critic {
        String filePath = this.file_a;
        if (!isFile_A) {
            filePath = this.file_b;
        }
        ArrayList<Object> header = new ArrayList();
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            String line;
            FileInputStream fstream = new FileInputStream(filePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            long countLine = 0L;
            boolean headerb = false;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                ++countLine;
                if (line.startsWith("!") || line.isEmpty()) continue;
                String[] data = line.split("\t");
                if (!headerb) {
                    headerb = true;
                    header = new ArrayList<String>(Arrays.asList(data));
                    if (data.length >= 2) continue;
                    throw new SLIB_Ex_Critic("Corrupted file " + filePath + ", result line " + countLine + " header must contains at least two fields");
                }
                if (data.length != header.size()) {
                    throw new SLIB_Ex_Critic("Corrupted file " + filePath + ", result line " + countLine + " contains abnormal number of values considering header");
                }
                String entry = data[0] + "\t" + data[1];
                if (values.containsKey(entry)) {
                    throw new SLIB_Ex_Critic("Duplicate row " + entry + " line " + countLine);
                }
                String[] vals = Arrays.copyOfRange(data, 2, data.length);
                values.put(entry, ResultsMerger.implodeArray(vals));
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        if (isFile_A) {
            this.header_a = header;
            this.values_a = values;
        } else {
            this.header_b = header;
            this.values_b = values;
        }
    }

    private void loadDataIndex(boolean isFile_A) throws SLIB_Ex_Critic {
        String filePath = this.file_a;
        String filePathName = this.tmp_file_a_prefix;
        if (!isFile_A) {
            filePath = this.file_b;
            filePathName = this.tmp_file_b_prefix;
        }
        this.logger.info("Creating index for file " + filePath);
        ArrayList<Object> header = new ArrayList();
        HashMap<String, Long> values = new HashMap<String, Long>();
        int file_nb = 0;
        try {
            long countLine = 0L;
            long countLineFile = 0L;
            String fileSeparator = System.getProperty("file.separator");
            BufferedWriter outbuff = null;
            boolean headerb = false;
            BigFileReader reader = new BigFileReader(filePath);
            while (reader.hasNext()) {
                String line;
                if (countLineFile == 0L) {
                    FileWriter fstream = new FileWriter(this.tmp_dir + fileSeparator + filePathName + "_" + file_nb);
                    outbuff = new BufferedWriter(fstream);
                    if (isFile_A) {
                        ++this.file_number_a;
                    } else {
                        ++this.file_number_b;
                    }
                }
                if (!(line = reader.nextTrimmed()).startsWith("!") && !line.isEmpty()) {
                    String[] data = line.split("\t");
                    if (!headerb) {
                        headerb = true;
                        header = new ArrayList<String>(Arrays.asList(data));
                        if (data.length < 2) {
                            throw new SLIB_Ex_Critic("Corrupted file " + filePath + ", result line " + (countLine + 1L) + " header must contains at least two fields");
                        }
                    } else {
                        if (data.length != header.size()) {
                            throw new SLIB_Ex_Critic("Corrupted file " + filePath + ", result line " + (countLine + 1L) + " contains abnormal number of values considering header");
                        }
                        String entry = data[0] + "\t" + data[1];
                        if (values.containsKey(entry)) {
                            throw new SLIB_Ex_Critic("Duplicate row " + entry + " line " + (countLine + 1L));
                        }
                        values.put(entry, countLine);
                    }
                }
                outbuff.write(line + "\n");
                ++countLine;
                if (++countLineFile != (long)this.splitSize) continue;
                outbuff.close();
                ++file_nb;
                countLineFile = 0L;
                outbuff = null;
            }
            reader.close();
            if (outbuff != null) {
                outbuff.close();
            }
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        if (isFile_A) {
            this.header_a = header;
            this.values_a_index = values;
        } else {
            this.header_b = header;
            this.values_b_index = values;
        }
    }
}

