/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class MapUtils {
    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return MapUtils.sortByValue(map, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueDecreasing(Map<K, V> map) {
        return MapUtils.sortByValue(map, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return -((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<V, K> revert(Map<K, V> map) {
        HashMap<V, K> maprevert = new HashMap<V, K>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            maprevert.put(e.getValue(), e.getKey());
        }
        return maprevert;
    }

    public static <K, V> void toFile(Map<K, V> res, String output) throws IOException {
        int c = 0;
        try (PrintWriter writer = new PrintWriter(output, "UTF-8");){
            for (Map.Entry<K, V> e : res.entrySet()) {
                writer.println(c + "\t" + e.getKey().toString() + "\t" + e.getValue().toString());
                ++c;
            }
        }
    }
}

