/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.threads;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.threads.PoolLocker;
import slib.utils.threads.PoolWorker;

public class ThreadManager
extends PoolLocker {
    private static ThreadManager instance;
    Logger logger = LoggerFactory.getLogger(ThreadManager.class);
    private static final int MAX_THREAD_DEFAULT = 1;

    public static ThreadManager getSingleton() {
        if (instance == null) {
            instance = new ThreadManager();
        }
        return instance;
    }

    private ThreadManager() {
        super(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolWorker getMaxLoadPoolWorker() throws SLIB_Ex_Critic {
        Object object = this.lock;
        synchronized (object) {
            int allowedSize = this.capacity - this.running;
            this.running += allowedSize;
            PoolWorker poolWorker = new PoolWorker(allowedSize);
            this.logger.info("Create a pool worker of size " + allowedSize);
            return poolWorker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolWorker getPoolWorker(int size) throws SLIB_Ex_Critic {
        Object object = this.lock;
        synchronized (object) {
            if (size > this.capacity) {
                throw new SLIB_Ex_Critic("Error during pool worker request maximum Number of thread " + this.capacity + " requested " + size);
            }
            if (this.running + size > this.capacity) {
                throw new SLIB_Ex_Critic("Unable to allocate the requested number of threads, available " + (this.capacity - this.running) + " requested " + size);
            }
            this.running += size;
            this.logger.info("Create a pool worker of size " + size);
            PoolWorker poolWorker = new PoolWorker(size);
            return poolWorker;
        }
    }

    public void setMaxThread(int maxThread) {
        this.capacity = maxThread;
        this.logger.info("Setting maximal number of threads to " + this.capacity);
    }

    public int getMaxThread() {
        return this.capacity;
    }

    public void freeResource(int nbThread) {
        this.running -= nbThread;
    }
}

