Slib
====

`Slib` is a JAVA library dedicated to semantic data mining based on texts and/or ontology processing. The library is composed of various modules dedicated to specific treatments - they can be used in the context of information retrieval, data analysis, recommendation system design...


* *slib-sml*, the module dedicated to [The Semantic Measures Library](http://www.semantic-measures-library.org) (SML), a library dedicated to semantic measures (similarity/relatedness) computation, evaluation and analysis. See dedicated web site: http://www.semantic-measures-library.org for more information on both semantic measures and this module.

* *slib-graph* a simple in-memory graph engine used to manipulate graphs of URIs - based on on the sesame library (RDF/OWL data loading...). This module provides an easy way to process semantic graphs (e.g. RDF graph) as graphs in which traversal can easily be performed. Numerous algorithms commonly used to process semantic graphs are implemented.
                                                                                 
* *slib-tools* various command-line tools performing processes on semantic graph/data
    * [SML-Toolkit](https://github.com/sharispe/slib/tree/master/slib-tools/slib-tools-sml-toolkit), a command-line tool dedicated to semantic similarity/relatedness computation.
    * Ontofocus, a command-line tool which can be used to perform efficient transitive reductions on potentially large taxonomies.
    
* *slib-utils* SLIB Utility classes
* *slib-indexer* Module which provides easy-to-use utility classes for indexing specific datasets.
* *slib-example* Source code examples


## Licence

[Cecill license](http://www.cecill.info/licences.en.html): a free software license adapted to both international and French legal matters, in the spirit of and retaining compatibility with the GNU General Public License (src: Wikipedia).
        
