% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_corr_plot.R
\name{model_corr_plot}
\alias{model_corr_plot}
\title{Compare Prediction Scores for ProteinGym Models}
\usage{
model_corr_plot(uniprotId, model1 = "AlphaMissense", model2 = "GEMME")
}
\arguments{
\item{uniprotId}{\code{character()} a valid UniProt accession identifier.}

\item{model1}{\code{character()} first model to plot.}

\item{model2}{\code{character()} second model to plot.}
}
\value{
\code{model_corr_plot()} returns a \code{ggplot} object visualizing
the Spearman correlation between the predicted scores generated by two
models in ProteinGym and prints the p-value of the analysis to the console.
}
\description{
\code{model_corr_plot()} runs a Spearman correlation
between predicted model scores for two models in ProteinGym v1.2.
Returns a ggplot object for visualization.
}
\details{
For \code{model_corr_plot()}:

\code{model1} and \code{model2} must be valid models.
To view the possible zero-shot and semi-supervised models available in
ProteinGym v1.2 run \code{ProteinGymR::available_models()} or
\code{ProteinGymR::supervised_available_models()}, respectively, or set the
model to 'AlphaMissense' for AlphaMissense predictions.
If no models are specified, the default loads in AlphaMissense and GEMME.
}
\examples{

# Use defaults. Only requires uniprotId
model_corr_plot(uniprotId = "Q9NV35")

model_corr_plot(
    uniprotId = "P04637",
    model1 = "Kermut",
    model2 = "EVE_single"
)

}
\references{
Cheng et al.,
Accurate proteome-wide missense variant effect prediction with AlphaMissense.
\emph{Science} 381, eadg7492. DOI:10.1126/science.adg7492.

Notin, P., Kollasch, A., Ritter, D., van Niekerk, L., Paul, S.,
Spinner, H., Rollins, N., Shaw, A., Orenbuch, R., Weitzman, R., Frazer, J.,
Dias, M., Franceschi, D., Gal, Y., & Marks, D. (2023).
ProteinGym: Large-Scale
Benchmarks for Protein Fitness Prediction and Design. In A. Oh, T. Neumann,
A. Globerson, K. Saenko, M. Hardt, & S. Levine (Eds.), \emph{Advances in
Neural Information Processing Systems} (Vol. 36, pp. 64331-64379).
Curran Associates, Inc.
}
