#' 
#' CNV datasets from TCGA project
#'
#' Package provides CNV datasets from The Cancer Genome Atlas Project for all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for the date: \code{2015-11-01}. The process is described here: \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data} family can be found here: \code{browseVignettes("RTCGA")}
#' Data format is explained here https://wiki.nci.nih.gov/display/TCGA/Retrieving+Data+Using+the+Data+Matrix
#' Converting \pkg{RTCGA.CNV} datasets from \code{data.frames} to Bioconductor classes is explained here \link{convertTCGA}.
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @return Data frames with CNV data.
#' 
#' @import RTCGA
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' @name CNV
#' @rdname CNV
#' @aliases ACC.CNV,BLCA.CNV,BRCA.CNV,CESC.CNV,CHOL.CNV,COAD.CNV,COADREAD.CNV,DLBC.CNV,ESCA.CNV,GBM.CNV,GBMLGG.CNV,HNSC.CNV,KICH.CNV,KIPAN.CNV,KIRC.CNV,KIRP.CNV,LAML.CNV,LGG.CNV,LIHC.CNV,LUAD.CNV,LUSC.CNV,MESO.CNV,OV.CNV,PAAD.CNV,PCPG.CNV,PRAD.CNV,READ.CNV,SARC.CNV,SKCM.CNV,STAD.CNV,TGCT.CNV,THCA.CNV,THYM.CNV,UCEC.CNV,UCS.CNV,UVM.CNV
#' 
"ACC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"BLCA.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"BRCA.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"CESC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"CHOL.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"COAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"COADREAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"DLBC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"ESCA.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"GBM.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"GBMLGG.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"HNSC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"KICH.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"KIPAN.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"KIRC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"KIRP.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"LAML.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"LGG.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"LIHC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"LUAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"LUSC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"MESO.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"OV.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"PAAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"PCPG.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"PRAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"READ.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"SARC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"SKCM.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"STAD.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"STES.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"TGCT.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"THCA.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"THYM.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"UCEC.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"UCS.CNV"
#' @name CNV
#' @rdname CNV
#' @format NULL
#' 
"UVM.CNV"