% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mRNA_datasets.R
\docType{data}
\name{mRNA}
\alias{mRNA}
\alias{BRCA.mRNA}
\alias{BRCA.mRNA,COAD.mRNA,COADREAD.mRNA,GBMLGG.mRNA,KIPAN.mRNA,KIRC.mRNA,KIRP.mRNA,LGG.mRNA,LUAD.mRNA,LUSC.mRNA,OV.mRNA,READ.mRNA,UCEC.mRNA}
\alias{COAD.mRNA}
\alias{COADREAD.mRNA}
\alias{GBMLGG.mRNA}
\alias{KIPAN.mRNA}
\alias{KIRC.mRNA}
\alias{KIRP.mRNA}
\alias{LGG.mRNA}
\alias{LUAD.mRNA}
\alias{LUSC.mRNA}
\alias{OV.mRNA}
\alias{READ.mRNA}
\alias{UCEC.mRNA}
\title{mRNA datasets from TCGA project}
\source{
\url{http://gdac.broadinstitute.org/}
}
\usage{
BRCA.mRNA

COAD.mRNA

COADREAD.mRNA

GBMLGG.mRNA

KIPAN.mRNA

KIRC.mRNA

KIRP.mRNA

LGG.mRNA

LUAD.mRNA

LUSC.mRNA

OV.mRNA

READ.mRNA

UCEC.mRNA
}
\value{
Data frames with mRNA data.
}
\description{
Package provides mRNA datasets from The Cancer Genome Atlas Project for
all cohorts types from \url{http://gdac.broadinstitute.org/}.
Data were downloaded using \link{RTCGA-package} and contain snapshots for
the date: \code{2015-11-01}. The process is described here:
\url{http://rtcga.github.io/RTCGA/}.
Use cases, examples and information about datasets in \pkg{RTCGA.data}
family can be found here: \code{browseVignettes("RTCGA")}. mRNA data format
is explained here \url{https://wiki.nci.nih.gov/display/TCGA/Gene+expression+data}.
Converting \pkg{RTCGA.mRNA} datasets from \code{data.frames} to Bioconductor classes is explained here \link{convertTCGA}.
}
\details{
\code{browseVignettes("RTCGA")}
}
\examples{

\dontrun{
browseVignettes("RTCGA")
}


}
\keyword{datasets}
