
\name{SomaticCancerAlterations-data}

\docType{data}

\alias{SomaticCancerAlterations-data}

\alias{meta}
\alias{blca_tcga}
\alias{cesc_tcga}
\alias{gbm_tcga}
\alias{hnsc_tcga}
\alias{kirc_tcga}
\alias{lgg_tcga}
\alias{luad_tcga}
\alias{lusc_tcga}
\alias{ov_tcga}
\alias{paad_tcga}
\alias{prad_tcga}
\alias{skcm_tcga}
\alias{stad_tcga}
\alias{thca_tcga}
\alias{ucec_tcga}

\title{Somatic Cancer Alterations Data Sets}

\description{
  Data sets with studies of somatic cancer alterations.
}

\value{
  A 'GRanges' object for each study.  Each row corresponds to a somatic
  variant reported in the respective study, with the coordinates
  refering to the location on the reference genome.  
}

\details{
  Currently, the data sets include somatic mutations (SNVs and indels)
  of the publically available TCGA studies.  Further studies will be
  included in the future.
  
  For details on the TCGA mutation calls, please see the TCGA documentation
  \url{https://wiki.nci.nih.gov/display/TCGA/TCGA+Data+Primer}.  Please
  note that the mutational calling was performed by different centers.  The
  original '*.maf' files can be obtained from the TCGA data portal
  \url{https://tcga-data.nci.nih.gov/tcgafiles/ftp_auth/distro_ftpusers/anonymous/tumor/}.

  After importing, the data is automatically processed to improve
  consistency across studies and remove common
  artifacts in the annotation.  The most obvious changes are:

  \itemize{
    \item{Only studies cleared for unrestricted usage are included (see
      \url{http://cancergenome.nih.gov/publications/publicationguidelines}).}
    \item{Only studies processed by the Broad Instutite are considered
      at the moment.}
    \item{All variants located on the mitochondrium are mapped to the
      sequence identifier 'MT' (note that the original files contain both
      'MT' and 'M' mixed).}
    \item{All locations are now consistent with the 1000genomes reference
      sequence (NCBI37 coordinates).}
  }

  About the TCGA data:

  \dQuote{All data generated by The Cancer Genome Atlas (TCGA) Research Network
  are made open to the public through the Data Coordinating Center and
  the TCGA Data Portal.}  For details on the usage of the data, please
  have a look at
  \url{http://cancergenome.nih.gov/abouttcga/policies/publicationguidelines}.
}
  
\references{
  \url{https://tcga-data.nci.nih.gov/tcga/}
}

\seealso{
  \code{\link[SomaticCancerAlterations]{SomaticCancerAlterations-functions}}

  \code{\link[SomaticCancerAlterations]{SomaticCancerAlterations-package}}
}

\examples{
all_datasets = scaListDatasets()
grl = scaLoadDatasets(all_datasets[1])
}

\keyword{datasets}
