% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physiologies.R
\name{physiologies}
\alias{physiologies}
\title{Import physiologies (for devs)}
\usage{
physiologies(keyword = "all", fullSource = FALSE)
}
\arguments{
\item{keyword}{Character vector with one or more valid keywords.
Valid keyboards can be checked with \code{showPhys}. If 'all', all
physiologies are imported.}

\item{fullSource}{Logical. If \code{TRUE}, the Attribute_source column will
contain full source information. If \code{FALSE}, the Attribute_source column
will contain shortened versions of the sources. Default is \code{FALSE}.}
}
\value{
A list of data.frames in tidy format.
}
\description{
\code{physiologies} imports a list of data.frames. This data is in "raw"
state before cleaning and going through the data imputation steps. It
should be used by developers/curators of the package.
}
\examples{
l <- physiologies('all')
df <- physiologies('aerophilicity')[[1]]

}
