% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{curatedPCaDatasets_ren}
\alias{curatedPCaDatasets_ren}
\title{Ren et al. MAE-object}
\format{
An MAE object spanning 65 men with prostate cancer
\describe{
    \item{gex.relz}{matrix with 21046 rows and 65 columns, of gene expression
        data}
    \item{mut}{RaggedExperiment with 50625 rows and 65 columns, of mutation 
        data from cbioportal}
    \item{cibersort}{matrix with 22 rows and 65 columns, of cibersort based 
        deconvolution data}
    \item{xcell}{matrix with 39 rows and 65 columns, of xcell based 
        deconvolution data}
    \item{epic}{matrix with 8 rows and 65 columns, of epic based 
        deconvolution data}
    \item{quantiseq}{matrix with 11 rows and 65 columns, of quantiseq based 
        deconvolution data}
    \item{estimate}{data.frame with 4 rows and 65 columns, of cell types 
        based on ESTIMATE method}
    \item{scores}{matrix with 4 rows and 65 columns, of risk scores and AR 
        scores}
    \item{mcp}{matrix with 11 rows and 65 columns, of mcp-counter based 
        deconvolution data}
}
}
\source{
\url{https://www.cbioportal.org/study/summary?id=prad_eururol_2017}
}
\value{
A MultiAssayExperiment corresponding to the study and its available 
omics.
}
\description{
MultiAssayExperiment object containing gene expression (gex), mutations and 
immune cell estimates from Ren et al.
}
\details{
The data contains 14 disease free benign prostate hyperplasia 
samples and 53 prostate cancer samples.
}
\examples{
mae_ren <- getPCa('ren')
}
\references{
(\href{https://pubmed.ncbi.nlm.nih.gov/28927585/}{PubMed})
}
\keyword{datasets}
