% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WuKidneyData.R
\name{WuKidneyData}
\alias{WuKidneyData}
\title{Obtain the Wu kidney data}
\usage{
WuKidneyData(
  mode = c("healthy", "disease"),
  ensembl = FALSE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{mode}{String indicating whether to return data for healthy and/or diseased donors.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse kidney single-nuclei RNA-seq data from Wu et al. (2019).
}
\details{
Column metadata includes the single-cell technology and whether they came from a diseased or healthy individual.

If \code{mode} specifies both healthy and disease donors,
counts are only reported for the intersection of genes that are present for both donors.
This is because the original count matrices had differences in their annotation.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/wu-kidney}.
}
\examples{
sce <- WuKidneyData("disease")

}
\references{
Wu H et al. (2019). 
Advantages of single-nucleus over single-cell RNA sequencing of adult kidney: rare cell types and novel cell states revealed in fibrosis.
\emph{J. Am. Soc. Nephrol.} 30, 23-32.
}
\author{
Aaron Lun
}
