% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listPaths.R
\name{listPaths}
\alias{listPaths}
\title{List all paths for a dataset}
\usage{
listPaths(
  name,
  version,
  package = "scRNAseq",
  cache = cacheDirectory(),
  overwrite = FALSE,
  include.metadata = FALSE
)
}
\arguments{
\item{name}{String containing the name of the dataset.}

\item{version}{String containing the version of the dataset.}

\item{package}{String containing the name of the package.}

\item{cache, overwrite}{Arguments to pass to \code{\link[gypsum]{saveVersion}} or \code{\link[gypsum]{saveFile}}.}

\item{include.metadata}{Logical scalar indicating whether to report the metadata for each subdataset.}
}
\value{
If \code{include.metadata=FALSE}, a character vector containing the paths to subdatasets within the specified version of the dataset.
If \code{name} does not contain any subdatasets, \code{NA} is returned.

Otherwise, a \link[S4Vectors]{DFrame} is returned containing the metadata for each subdataset, e.g., the title and description.
More details can be found in the Bioconductor metadata schema at \url{https://github.com/ArtifactDB/bioconductor-metadata-index}.
}
\description{
List the available paths to subdatasets within a version of a given dataset.
}
\examples{
listPaths("he-organs-2020", "2023-12-21")
listPaths("he-organs-2020", "2023-12-21", include.metadata=TRUE)
listPaths("zeisel-brain-2015", "2023-12-14") # no subdatasets
listPaths("zeisel-brain-2015", "2023-12-14", include.metadata=TRUE) 

}
\author{
Aaron Lun
}
