% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaeData.R
\name{scaeDataGet}
\alias{scaeDataGet}
\title{Download and process demo dataset}
\usage{
scaeDataGet(dataset = c("pbmc_5k", "pbmc_10k", "pbmc_20k"))
}
\arguments{
\item{dataset}{character vector describing which dataset should be retrieved. Choose one as input.}
}
\value{
list with four elements containing file path and file names for the chosen dataset
}
\description{
Wrapper function used to retrieve a list containing the file path and file names for the chosen dataset.
The corresponding dataset is retrieved from \code{ExperimentHub}. The following demo datasets are available:
\itemize{
\item \strong{pbmc_5k}: using the following ExperimentHub entries: \strong{barcodes}(EH9453); \strong{features}(EH9454); \strong{counts matrix}(EH9455)
\item \strong{pbmc_10k}: using the following ExperimentHub entries: \strong{barcodes}(EH9456); \strong{features}(EH9457); \strong{counts matrix}(EH9458)
\item \strong{pbmc_20k}: using the following ExperimentHub entries: \strong{barcodes}(EH9459); \strong{features}(EH9460); \strong{counts matrix}(EH9461)
}
}
\examples{

if (interactive()) {
    scae_data_5k <- scaeDataGet(dataset = "pbmc_5k")
    scae_data_5k
}

}
