library("here")
library("sessioninfo")


outdir <- "spatialLIBD_files"
pkgname <- "spatialLIBD"


meta <- data.frame(
    Title = c(
        "Human_Pilot_DLPFC_Visium_spatialLIBD_spot_level_SCE",
        "Human_Pilot_DLPFC_Visium_spatialLIBD_layer_level_SCE",
        "Human_Pilot_DLPFC_Visium_spatialLIBD_modeling_results",
        "Human_DLPFC_Visium_sce_example"
    ),
    Description = c(
        "SingleCellExperiment object at the spot-level for the pilot human DLPFC spatial transcriptomics data from the Visium platform from 10x Genomics generated by the LIBD and available through the spatialLIBD Bioconductor package.",
        "SingleCellExperiment object at the layer-level for the pilot human DLPFC spatial transcriptomics data from the Visium platform from 10x Genomics generated by the LIBD and available through the spatialLIBD Bioconductor package.",
        "List of modeling results at the layer-level for the pilot human DLPFC spatial transcriptomics data from the Visium platform from 10x Genomics generated by the LIBD and available through the spatialLIBD Bioconductor package.",
        "SingleCellExperiment object at the spot-level for the pilot human DLPFC spatial transcriptomics data from the Visium platform from 10x Genomics generated by the LIBD and available through the spatialLIBD Bioconductor package. It is a subset of the main object for example purposes."
    ),
    BiocVersion = "3.10",
    Genome = "GRCh38",
    SourceType = "GTF",
    SourceUrl = "https://bioconductor.org/packages/spatialLIBD",
    SourceVersion = "Feb 19 2020",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "LIBD",
    Maintainer = "Leonardo Collado-Torres <lcolladotor@gmail.com>",
    RDataClass = c(
        "SingleCellExperiment",
        "SingleCellExperiment",
        "list",
        "SingleCellExperiment"
    ),
    DispatchClass = "Rda",
    RDataPath = file.path(
        pkgname,
        outdir,
        c(
            "Human_DLPFC_Visium_processedData_sce_scran_spatialLIBD.Rdata",
            "Human_DLPFC_Visium_processedData_sce_scran_sce_layer_spatialLIBD.Rdata",
            "Human_DLPFC_Visium_modeling_results.Rdata",
            "sce_sub_for_vignette.Rdata"
        )
    ),
    Tags = "Human_Pilot_DLPFC_Visium_spatialLIBD",
    row.names = NULL,
    stringsAsFactors = FALSE
)

write.csv(
    meta,
    file = here::here("inst", "extdata", "metadata_spatialLIBD.csv"),
    row.names = FALSE
)

## Check
if (FALSE) {
    AnnotationHubData::makeAnnotationHubMetadata(here::here(), fileName = "metadata_spatialLIBD.csv")
}

## Reproducibility information
print("Reproducibility information:")
Sys.time()
proc.time()
options(width = 120)
session_info()

# ─ Session info ───────────────────────────────────────────────────────────────────────────────────────────────────────
#  setting  value
#  version  R version 3.6.2 (2019-12-12)
#  os       macOS Catalina 10.15.2
#  system   x86_64, darwin15.6.0
#  ui       AQUA
#  language (EN)
#  collate  en_US.UTF-8
#  ctype    en_US.UTF-8
#  tz       America/New_York
#  date     2020-02-19
#
# ─ Packages ───────────────────────────────────────────────────────────────────────────────────────────────────────────
#  package                * version  date       lib source
#  AnnotationDbi            1.48.0   2019-10-29 [1] Bioconductor
#  AnnotationForge          1.28.0   2019-10-29 [1] Bioconductor
#  AnnotationHub          * 2.18.0   2019-10-29 [1] Bioconductor
#  AnnotationHubData      * 1.16.0   2019-10-29 [1] Bioconductor
#  askpass                  1.1      2019-01-13 [1] CRAN (R 3.6.0)
#  assertthat               0.2.1    2019-03-21 [1] CRAN (R 3.6.0)
#  backports                1.1.5    2019-10-02 [1] CRAN (R 3.6.0)
#  Biobase                  2.46.0   2019-10-29 [1] Bioconductor
#  BiocFileCache          * 1.10.2   2019-11-08 [1] Bioconductor
#  BiocGenerics           * 0.32.0   2019-10-29 [1] Bioconductor
#  BiocManager              1.30.10  2019-11-16 [1] CRAN (R 3.6.1)
#  BiocParallel             1.20.1   2019-12-21 [1] Bioconductor
#  BiocVersion              3.10.1   2019-06-06 [1] Bioconductor
#  biocViews                1.54.0   2019-10-29 [1] Bioconductor
#  biomaRt                  2.42.0   2019-10-29 [1] Bioconductor
#  Biostrings               2.54.0   2019-10-29 [1] Bioconductor
#  bit                      1.1-15.1 2020-01-14 [1] CRAN (R 3.6.0)
#  bit64                    0.9-7    2017-05-08 [1] CRAN (R 3.6.0)
#  bitops                   1.0-6    2013-08-17 [1] CRAN (R 3.6.0)
#  blob                     1.2.1    2020-01-20 [1] CRAN (R 3.6.0)
#  callr                    3.4.1    2020-01-24 [1] CRAN (R 3.6.2)
#  cli                      2.0.1    2020-01-08 [1] CRAN (R 3.6.0)
#  crayon                   1.3.4    2017-09-16 [1] CRAN (R 3.6.0)
#  curl                     4.3      2019-12-02 [1] CRAN (R 3.6.0)
#  data.table               1.12.8   2019-12-09 [1] CRAN (R 3.6.1)
#  DBI                      1.1.0    2019-12-15 [1] CRAN (R 3.6.0)
#  dbplyr                 * 1.4.2    2019-06-17 [1] CRAN (R 3.6.0)
#  DelayedArray             0.12.2   2020-01-06 [1] Bioconductor
#  desc                     1.2.0    2018-05-01 [1] CRAN (R 3.6.0)
#  devtools               * 2.2.1    2019-09-24 [1] CRAN (R 3.6.1)
#  digest                   0.6.23   2019-11-23 [1] CRAN (R 3.6.0)
#  dplyr                    0.8.3    2019-07-04 [1] CRAN (R 3.6.0)
#  ellipsis                 0.3.0    2019-09-20 [1] CRAN (R 3.6.0)
#  fansi                    0.4.1    2020-01-08 [1] CRAN (R 3.6.0)
#  fastmap                  1.0.1    2019-10-08 [1] CRAN (R 3.6.0)
#  formatR                  1.7      2019-06-11 [1] CRAN (R 3.6.0)
#  fs                       1.3.1    2019-05-06 [1] CRAN (R 3.6.0)
#  futile.logger          * 1.4.3    2016-07-10 [1] CRAN (R 3.6.0)
#  futile.options           1.0.1    2018-04-20 [1] CRAN (R 3.6.0)
#  GenomeInfoDb           * 1.22.0   2019-10-29 [1] Bioconductor
#  GenomeInfoDbData         1.2.2    2019-10-31 [1] Bioconductor
#  GenomicAlignments        1.22.1   2019-11-12 [1] Bioconductor
#  GenomicFeatures          1.38.1   2020-01-22 [1] Bioconductor
#  GenomicRanges          * 1.38.0   2019-10-29 [1] Bioconductor
#  glue                     1.3.1    2019-03-12 [1] CRAN (R 3.6.0)
#  graph                    1.64.0   2019-10-29 [1] Bioconductor
#  here                   * 0.1      2017-05-28 [1] CRAN (R 3.6.0)
#  hms                      0.5.3    2020-01-08 [1] CRAN (R 3.6.0)
#  htmltools                0.4.0    2019-10-04 [1] CRAN (R 3.6.0)
#  httpuv                   1.5.2    2019-09-11 [1] CRAN (R 3.6.0)
#  httr                     1.4.1    2019-08-05 [1] CRAN (R 3.6.0)
#  interactiveDisplayBase   1.24.0   2019-10-29 [1] Bioconductor
#  IRanges                * 2.20.2   2020-01-13 [1] Bioconductor
#  jsonlite                 1.6      2018-12-07 [1] CRAN (R 3.6.0)
#  lambda.r                 1.2.4    2019-09-18 [1] CRAN (R 3.6.0)
#  later                    1.0.0    2019-10-04 [1] CRAN (R 3.6.0)
#  lattice                  0.20-38  2018-11-04 [1] CRAN (R 3.6.2)
#  magrittr                 1.5      2014-11-22 [1] CRAN (R 3.6.0)
#  Matrix                   1.2-18   2019-11-27 [1] CRAN (R 3.6.2)
#  matrixStats              0.55.0   2019-09-07 [1] CRAN (R 3.6.0)
#  memoise                  1.1.0    2017-04-21 [1] CRAN (R 3.6.0)
#  mime                     0.8      2019-12-19 [1] CRAN (R 3.6.0)
#  openssl                  1.4.1    2019-07-18 [1] CRAN (R 3.6.0)
#  OrganismDbi              1.28.0   2019-10-29 [1] Bioconductor
#  pillar                   1.4.3    2019-12-20 [1] CRAN (R 3.6.0)
#  pkgbuild                 1.0.6    2019-10-09 [1] CRAN (R 3.6.0)
#  pkgconfig                2.0.3    2019-09-22 [1] CRAN (R 3.6.1)
#  pkgload                  1.0.2    2018-10-29 [1] CRAN (R 3.6.0)
#  prettyunits              1.1.1    2020-01-24 [1] CRAN (R 3.6.2)
#  processx                 3.4.1    2019-07-18 [1] CRAN (R 3.6.0)
#  progress                 1.2.2    2019-05-16 [1] CRAN (R 3.6.0)
#  promises                 1.1.0    2019-10-04 [1] CRAN (R 3.6.0)
#  ps                       1.3.0    2018-12-21 [1] CRAN (R 3.6.0)
#  purrr                    0.3.3    2019-10-18 [1] CRAN (R 3.6.0)
#  R6                       2.4.1    2019-11-12 [1] CRAN (R 3.6.1)
#  rappdirs                 0.3.1    2016-03-28 [1] CRAN (R 3.6.0)
#  RBGL                     1.62.1   2019-10-30 [1] Bioconductor
#  rBiopaxParser            2.26.0   2019-10-29 [1] Bioconductor
#  Rcpp                     1.0.3    2019-11-08 [1] CRAN (R 3.6.0)
#  RCurl                    1.98-1.1 2020-01-19 [1] CRAN (R 3.6.0)
#  remotes                  2.1.0    2019-06-24 [1] CRAN (R 3.6.0)
#  rlang                    0.4.3    2020-01-24 [1] CRAN (R 3.6.2)
#  rprojroot                1.3-2    2018-01-03 [1] CRAN (R 3.6.0)
#  Rsamtools                2.2.1    2019-11-06 [1] Bioconductor
#  RSQLite                  2.2.0    2020-01-07 [1] CRAN (R 3.6.0)
#  rtracklayer              1.46.0   2019-10-29 [1] Bioconductor
#  RUnit                    0.4.32   2018-05-18 [1] CRAN (R 3.6.0)
#  S4Vectors              * 0.24.3   2020-01-18 [1] Bioconductor
#  sessioninfo            * 1.1.1    2018-11-05 [1] CRAN (R 3.6.0)
#  shiny                    1.4.0    2019-10-10 [1] CRAN (R 3.6.0)
#  stringi                  1.4.5    2020-01-11 [1] CRAN (R 3.6.0)
#  stringr                  1.4.0    2019-02-10 [1] CRAN (R 3.6.0)
#  SummarizedExperiment     1.16.1   2019-12-19 [1] Bioconductor
#  testthat               * 2.3.1    2019-12-01 [1] CRAN (R 3.6.0)
#  tibble                   2.1.3    2019-06-06 [1] CRAN (R 3.6.0)
#  tidyselect               0.2.5    2018-10-11 [1] CRAN (R 3.6.0)
#  usethis                * 1.5.1    2019-07-04 [1] CRAN (R 3.6.0)
#  vctrs                    0.2.2    2020-01-24 [1] CRAN (R 3.6.2)
#  withr                    2.1.2    2018-03-15 [1] CRAN (R 3.6.0)
#  XML                      3.99-0.3 2020-01-20 [1] CRAN (R 3.6.0)
#  xtable                   1.8-4    2019-04-21 [1] CRAN (R 3.6.0)
#  XVector                  0.26.0   2019-10-29 [1] Bioconductor
#  yaml                     2.2.0    2018-07-25 [1] CRAN (R 3.6.0)
#  zlibbioc                 1.32.0   2019-10-29 [1] Bioconductor
#
# [1] /Library/Frameworks/R.framework/Versions/3.6/Resources/library
