% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_limits.R
\name{frame_limits}
\alias{frame_limits}
\title{Identify the image limits}
\usage{
frame_limits(
  spe,
  sampleid,
  image_id = "lowres",
  visium_grid = list(row_min = 0, row_max = 77, col_min = 0, col_max = 127,
    fiducial_vs_capture_edge = (8 - 6.5) * 1000/2/100)
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{visium_grid}{A named list with the parameters known about the Visium
grid. This can change for Visium HD vs regular Visium for example.}
}
\value{
A named list with \code{y_min}, \code{y_max}, \code{x_min}, and \code{x_max} pixels from
the selected image that can be used for cropping the image.
}
\description{
This function is useful for automatically cropping the images. It finds
the edge points (min and max on both the X and Y axis) in pixels based
on a particular image. This function takes advantage of the known design
of Visium slides as documented at
\url{https://support.10xgenomics.com/spatial-gene-expression/software/pipelines/latest/output/spatial}
and
\url{https://kb.10xgenomics.com/hc/en-us/articles/360041426992}. That is,
that for a regular Visium slide, the array row has a range from 0 to 77,
the array col from 0 to 127, the capture area has a 6.5 mm edge length, the
the fiducial frame area has an edge of 8 mm, and spot centers are about 100
um from each other.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Obtain the frame limits for one sample
    frame_limits(spe, sampleid = "151673")
}

}
\seealso{
Other Spatial cluster visualization functions: 
\code{\link{vis_clus}()},
\code{\link{vis_clus_p}()},
\code{\link{vis_grid_clus}()},
\code{\link{vis_image}()}
}
\author{
Louise Huuki-Myers and Leonardo Collado-Torres
}
\concept{Spatial cluster visualization functions}
